/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class CrossCompactionTaskResource {
    private List<TsFileResource> seqFiles = new ArrayList<TsFileResource>();
    private List<TsFileResource> unseqFiles = new ArrayList<TsFileResource>();
    private long totalMemoryCost = 0L;
    private long totalFileSize = 0L;
    private float totalSeqFileSize;
    private float totalUnseqFileSize;
    private long totalFileNums = 0L;

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    public void sortSeqFiles(List<TsFileResource> seqFilesCandidates) {
        HashMap<TsFileResource, Boolean> selectedFileMap = new HashMap<TsFileResource, Boolean>();
        for (TsFileResource selectedFile : this.seqFiles) {
            selectedFileMap.put(selectedFile, true);
        }
        ArrayList<TsFileResource> sortedSeqFiles = new ArrayList<TsFileResource>();
        for (TsFileResource file : seqFilesCandidates) {
            if (!selectedFileMap.containsKey(file)) continue;
            sortedSeqFiles.add(file);
        }
        this.seqFiles = sortedSeqFiles;
    }

    public void putResources(TsFileResource unseqFile, List<TsFileResource> seqFiles, long memoryCost) {
        this.addUnseqFile(unseqFile);
        this.addTargetSeqFiles(seqFiles);
        this.updateMemoryCost(memoryCost);
    }

    private void addUnseqFile(TsFileResource file) {
        this.unseqFiles.add(file);
        this.totalUnseqFileSize += (float)file.getTsFileSize();
        this.countStatistic(file);
    }

    private void addTargetSeqFiles(List<TsFileResource> targetSeqFiles) {
        targetSeqFiles.forEach(this::addSeqFile);
    }

    private void addSeqFile(TsFileResource file) {
        this.seqFiles.add(file);
        this.totalSeqFileSize += (float)file.getTsFileSize();
        this.countStatistic(file);
    }

    private void updateMemoryCost(long newMemoryCost) {
        this.totalMemoryCost = Math.max(this.totalMemoryCost, newMemoryCost);
    }

    private void countStatistic(TsFileResource file) {
        this.totalFileSize += file.getTsFileSize();
        ++this.totalFileNums;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }

    public long getTotalMemoryCost() {
        return this.totalMemoryCost;
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }

    public float getTotalSeqFileSize() {
        return this.totalSeqFileSize;
    }

    public float getTotalUnseqFileSize() {
        return this.totalUnseqFileSize;
    }

    public long getTotalFileNums() {
        return this.totalFileNums;
    }

    public boolean isValid() {
        return !this.unseqFiles.isEmpty() && !this.seqFiles.isEmpty();
    }
}

