/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.common.enums;

/**
 * Operation type
 */
public enum OperationType {

    CREATE,

    UPDATE,

    /**
     * Insert or update
     */
    UPSERT,

    DELETE,

    GET,

    LIST,

    SUSPEND,

    START;

    public static OperationType forOperationType(String type) {
        for (OperationType operationType : values()) {
            if (operationType.name().equalsIgnoreCase(type)) {
                return operationType;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported operation type for %s", type));
    }
}
