/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;

public class UnAckedTopicMessageTracker
extends UnAckedMessageTracker {
    public UnAckedTopicMessageTracker(PulsarClientImpl client, ConsumerBase<?> consumerBase, long ackTimeoutMillis) {
        super(client, consumerBase, ackTimeoutMillis);
    }

    public UnAckedTopicMessageTracker(PulsarClientImpl client, ConsumerBase<?> consumerBase, long ackTimeoutMillis, long tickDurationMillis) {
        super(client, consumerBase, ackTimeoutMillis, tickDurationMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeTopicMessages(String topicName) {
        this.writeLock.lock();
        try {
            int removed = 0;
            Iterator iterator = ((ConcurrentHashMap.KeySetView)this.messageIdPartitionMap.keySet()).iterator();
            while (iterator.hasNext()) {
                MessageId messageId = (MessageId)iterator.next();
                if (!(messageId instanceof TopicMessageIdImpl) || !((TopicMessageIdImpl)messageId).getTopicPartitionName().contains(topicName)) continue;
                ConcurrentOpenHashSet exist = (ConcurrentOpenHashSet)this.messageIdPartitionMap.get(messageId);
                if (exist != null) {
                    exist.remove(messageId);
                }
                iterator.remove();
                ++removed;
            }
            int n = removed;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

