/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.List;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.SnapshotUpdate;
import org.apache.iceberg.expressions.Expression;
import org.immutables.value.Value;

@Value.Enclosing
public interface RewritePositionDeleteFiles
extends SnapshotUpdate<RewritePositionDeleteFiles, Result> {
    public static final String PARTIAL_PROGRESS_ENABLED = "partial-progress.enabled";
    public static final boolean PARTIAL_PROGRESS_ENABLED_DEFAULT = false;
    public static final String PARTIAL_PROGRESS_MAX_COMMITS = "partial-progress.max-commits";
    public static final int PARTIAL_PROGRESS_MAX_COMMITS_DEFAULT = 10;
    public static final String MAX_CONCURRENT_FILE_GROUP_REWRITES = "max-concurrent-file-group-rewrites";
    public static final int MAX_CONCURRENT_FILE_GROUP_REWRITES_DEFAULT = 5;
    public static final String REWRITE_JOB_ORDER = "rewrite-job-order";
    public static final String REWRITE_JOB_ORDER_DEFAULT = RewriteJobOrder.NONE.orderName();

    public RewritePositionDeleteFiles filter(Expression var1);

    @Value.Immutable
    public static interface FileGroupInfo {
        public int globalIndex();

        public int partitionIndex();

        public StructLike partition();
    }

    @Value.Immutable
    public static interface FileGroupRewriteResult {
        public FileGroupInfo info();

        public int rewrittenDeleteFilesCount();

        public int addedDeleteFilesCount();

        public long rewrittenBytesCount();

        public long addedBytesCount();
    }

    @Value.Immutable
    public static interface Result {
        public List<FileGroupRewriteResult> rewriteResults();

        default public int rewrittenDeleteFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::rewrittenDeleteFilesCount).sum();
        }

        default public int addedDeleteFilesCount() {
            return this.rewriteResults().stream().mapToInt(FileGroupRewriteResult::addedDeleteFilesCount).sum();
        }

        default public long rewrittenBytesCount() {
            return this.rewriteResults().stream().mapToLong(FileGroupRewriteResult::rewrittenBytesCount).sum();
        }

        default public long addedBytesCount() {
            return this.rewriteResults().stream().mapToLong(FileGroupRewriteResult::addedBytesCount).sum();
        }
    }
}

