/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.functions.casting.CastCodeBlock;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.EncodingUtils;
import scala.Function1;

final class CastRuleUtils {
    static final String EMPTY_STR_LITERAL = "\"\"";

    CastRuleUtils() {
    }

    static String nullLiteral(boolean legacyBehaviour) {
        return legacyBehaviour ? CastRuleUtils.strLiteral("null") : CastRuleUtils.strLiteral("NULL");
    }

    static String operator(Object left, String operator, Object right) {
        return left + operator + right;
    }

    static String staticCall(Class<?> clazz, String methodName, Object ... args) {
        return CastRuleUtils.methodCall(CodeGenUtils.className(clazz), methodName, args);
    }

    static String staticCall(Method staticMethod, Object ... args) {
        return CastRuleUtils.functionCall(CodeGenUtils.qualifyMethod(staticMethod), args);
    }

    static String constructorCall(Class<?> clazz, Object ... args) {
        return CastRuleUtils.functionCall("new " + CodeGenUtils.className(clazz), args);
    }

    static String methodCall(String instanceTerm, String methodName, Object ... args) {
        return CastRuleUtils.functionCall(instanceTerm + "." + methodName, args);
    }

    private static String functionCall(String functionName, Object ... args) {
        return functionName + "(" + Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", ")) + ")";
    }

    static String newArray(String innerType, String arraySize) {
        return "new " + innerType + "[" + arraySize + "]";
    }

    static String stringConcat(Object ... args) {
        return Arrays.stream(args).map(Object::toString).collect(Collectors.joining(" + "));
    }

    static String accessStaticField(Class<?> clazz, String fieldName) {
        return CodeGenUtils.className(clazz) + "." + fieldName;
    }

    static String arrayLength(String arrayTerm) {
        return arrayTerm + ".length";
    }

    static String arrayElement(String arrayTerm, String indexTerm) {
        return arrayTerm + "[" + indexTerm + "]";
    }

    static String ternaryOperator(String condition, String ifTrue, String ifFalse) {
        return "((" + condition + ") ? (" + ifTrue + ") : (" + ifFalse + "))";
    }

    static String strLiteral(String str) {
        return "\"" + EncodingUtils.escapeJava((String)str) + "\"";
    }

    static String cast(String target, String expression) {
        return "((" + target + ")(" + expression + "))";
    }

    static String castToPrimitive(LogicalType target, String expression) {
        return CastRuleUtils.cast(CodeGenUtils.primitiveTypeTermForType(target), expression);
    }

    static String unbox(String term, LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return CastRuleUtils.methodCall(term, "booleanValue", new Object[0]);
            }
            case TINYINT: {
                return CastRuleUtils.methodCall(term, "byteValue", new Object[0]);
            }
            case SMALLINT: {
                return CastRuleUtils.methodCall(term, "shortValue", new Object[0]);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return CastRuleUtils.methodCall(term, "intValue", new Object[0]);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return CastRuleUtils.methodCall(term, "longValue", new Object[0]);
            }
            case FLOAT: {
                return CastRuleUtils.methodCall(term, "floatValue", new Object[0]);
            }
            case DOUBLE: {
                return CastRuleUtils.methodCall(term, "doubleValue", new Object[0]);
            }
            case DISTINCT_TYPE: {
                return CastRuleUtils.unbox(term, ((DistinctType)type).getSourceType());
            }
        }
        return term;
    }

    static String box(String term, LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return CastRuleUtils.staticCall(Boolean.class, "valueOf", term);
            }
            case TINYINT: {
                return CastRuleUtils.staticCall(Byte.class, "valueOf", term);
            }
            case SMALLINT: {
                return CastRuleUtils.staticCall(Short.class, "valueOf", term);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return CastRuleUtils.staticCall(Integer.class, "valueOf", term);
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return CastRuleUtils.staticCall(Long.class, "valueOf", term);
            }
            case FLOAT: {
                return CastRuleUtils.staticCall(Float.class, "valueOf", term);
            }
            case DOUBLE: {
                return CastRuleUtils.staticCall(Double.class, "valueOf", term);
            }
            case DISTINCT_TYPE: {
                CastRuleUtils.box(term, ((DistinctType)type).getSourceType());
            }
        }
        return term;
    }

    static String binaryWriterWriteField(CodeGeneratorCastRule.Context context, String writerTerm, LogicalType logicalType, String indexTerm, String fieldValTerm) {
        return CodeGenUtils.binaryWriterWriteField((Function1<LogicalType, String>)((Function1)context::declareTypeSerializer), String.valueOf(indexTerm), fieldValTerm, writerTerm, logicalType);
    }

    static String binaryWriterWriteNull(String writerTerm, LogicalType logicalType, String indexTerm) {
        return CodeGenUtils.binaryWriterWriteNull(indexTerm, writerTerm, logicalType);
    }

    static final class CodeWriter {
        StringBuilder builder = new StringBuilder();

        CodeWriter() {
        }

        public CodeWriter declStmt(String varType, String varName, String value) {
            return this.stmt(varType + " " + varName + " = " + value);
        }

        public CodeWriter declStmt(Class<?> clazz, String varName, String value) {
            return this.declStmt(CodeGenUtils.className(clazz), varName, value);
        }

        public CodeWriter declPrimitiveStmt(LogicalType logicalType, String varName, String value) {
            return this.declStmt(CodeGenUtils.primitiveTypeTermForType(logicalType), varName, value);
        }

        public CodeWriter declPrimitiveStmt(LogicalType logicalType, String varName) {
            return this.declStmt(CodeGenUtils.primitiveTypeTermForType(logicalType), varName, CodeGenUtils.primitiveDefaultValue(logicalType));
        }

        public CodeWriter declStmt(String varType, String varName) {
            return this.stmt(varType + " " + varName);
        }

        public CodeWriter declStmt(Class<?> clazz, String varName) {
            return this.declStmt(CodeGenUtils.className(clazz), varName);
        }

        public CodeWriter assignStmt(String varName, String value) {
            return this.stmt(varName + " = " + value);
        }

        public CodeWriter assignPlusStmt(String varName, String value) {
            return this.stmt(varName + " += " + value);
        }

        public CodeWriter assignArrayStmt(String varName, String index, String value) {
            return this.stmt(varName + "[" + index + "] = " + value);
        }

        public CodeWriter stmt(String stmt) {
            this.builder.append(stmt).append(';').append('\n');
            return this;
        }

        public CodeWriter forStmt(String upperBound, BiConsumer<String, CodeWriter> bodyWriterConsumer) {
            String indexTerm = CodeGenUtils.newName("i");
            CodeWriter innerWriter = new CodeWriter();
            this.builder.append("for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(upperBound).append("; ").append(indexTerm).append("++) {\n");
            bodyWriterConsumer.accept(indexTerm, innerWriter);
            this.builder.append(innerWriter).append("}\n");
            return this;
        }

        public CodeWriter breakStmt() {
            this.builder.append("break;\n");
            return this;
        }

        public CodeWriter ifStmt(String condition, Consumer<CodeWriter> bodyWriterConsumer) {
            CodeWriter innerWriter = new CodeWriter();
            this.builder.append("if (").append(condition).append(") {\n");
            bodyWriterConsumer.accept(innerWriter);
            this.builder.append(innerWriter).append("}\n");
            return this;
        }

        public CodeWriter ifStmt(String condition, Consumer<CodeWriter> thenWriterConsumer, Consumer<CodeWriter> elseWriterConsumer) {
            CodeWriter thenWriter = new CodeWriter();
            CodeWriter elseWriter = new CodeWriter();
            this.builder.append("if (").append(condition).append(") {\n");
            thenWriterConsumer.accept(thenWriter);
            this.builder.append(thenWriter).append("} else {\n");
            elseWriterConsumer.accept(elseWriter);
            this.builder.append(elseWriter).append("}\n");
            return this;
        }

        public CodeWriter tryCatchStmt(Consumer<CodeWriter> bodyWriterConsumer, BiConsumer<String, CodeWriter> catchConsumer) {
            return this.tryCatchStmt(bodyWriterConsumer, Throwable.class, catchConsumer);
        }

        public CodeWriter tryCatchStmt(Consumer<CodeWriter> bodyWriterConsumer, Class<? extends Throwable> catchClass, BiConsumer<String, CodeWriter> catchConsumer) {
            String exceptionTerm = CodeGenUtils.newName("e");
            CodeWriter bodyWriter = new CodeWriter();
            CodeWriter catchWriter = new CodeWriter();
            this.builder.append("try {\n");
            bodyWriterConsumer.accept(bodyWriter);
            this.builder.append(bodyWriter).append("} catch (").append(CodeGenUtils.className(catchClass)).append(" ").append(exceptionTerm).append(") {\n");
            catchConsumer.accept(exceptionTerm, catchWriter);
            this.builder.append(catchWriter).append("}\n");
            return this;
        }

        public CodeWriter append(CastCodeBlock codeBlock) {
            this.builder.append(codeBlock.getCode());
            return this;
        }

        public CodeWriter throwStmt(String expression) {
            this.builder.append("throw ").append(expression).append(";");
            return this;
        }

        public CodeWriter appendBlock(String codeBlock) {
            this.builder.append(codeBlock);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

