/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.inlong.common.util.StringUtil;
import org.xerial.snappy.Snappy;

public class Utils {
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    private static ConcurrentHashMap<String, AtomicLong> timeMap = new ConcurrentHashMap();

    public static double toKB(long bytes) {
        return (double)bytes / 1024.0;
    }

    public static double toMB(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    public static double toGB(long bytes) {
        return (double)bytes / 1024.0 / 1024.0 / 1024.0;
    }

    public static String ipInt2String(int ipInt) {
        byte[] bytes = new byte[]{(byte)(ipInt >>> 24 & 0xFF), (byte)(ipInt >>> 16 & 0xFF), (byte)(ipInt >>> 8 & 0xFF), (byte)(ipInt & 0xFF)};
        return "" + (bytes[0] & 0xFF) + '.' + (bytes[1] & 0xFF) + '.' + (bytes[2] & 0xFF) + '.' + (bytes[3] & 0xFF);
    }

    public static String bytesToStr(byte[] value, String charsetName, String defaultValue) {
        if (value == null || value.length == 0) {
            return defaultValue;
        }
        try {
            String str = new String(value, charsetName);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return defaultValue;
        }
    }

    public static <T> Set<T> toSet(T ... values) {
        HashSet<T> result = new HashSet<T>();
        for (T v : values) {
            result.add(v);
        }
        return result;
    }

    public static <T> List<T> toList(T ... values) {
        ArrayList<T> result = new ArrayList<T>();
        for (T v : values) {
            result.add(v);
        }
        return result;
    }

    public static String exceptionMsg(Throwable exception) {
        if (exception == null) {
            return "";
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(exception.getClass().getSimpleName() + ",");
            sb.append(exception.getMessage());
            Throwable cause = exception.getCause();
            if (cause != null) {
                sb.append("," + cause.getMessage());
            }
            return sb.toString();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String doubleToStr(double value, int fractionDigits) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(fractionDigits);
        String str = format.format(value);
        return str;
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replaceAll("-", "");
    }

    public static String toStr(String splitChar, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        int size = objs.length;
        int lastIndex = size - 1;
        for (int i = 0; i < size; ++i) {
            sb.append(objs[i]);
            if (i >= lastIndex) continue;
            sb.append(splitChar);
        }
        return sb.toString();
    }

    public static <E> List<List<E>> splitList(List<E> list, int splitSize) {
        ArrayList result = new ArrayList();
        if (list == null || list.size() <= splitSize) {
            return result;
        }
        int size = 0;
        ArrayList<E> subList = new ArrayList<E>();
        for (E e : list) {
            if (size++ > splitSize) {
                result.add(subList);
                size = 0;
                subList = new ArrayList();
                continue;
            }
            subList.add(e);
        }
        return result;
    }

    public static byte[] compressGZip(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzipDecompress(byte[] data, int startOffset, int dataLength) throws IOException {
        int initBufSize = 8192;
        try (GZIPInputStream gzip = null;){
            int readNum;
            ByteArrayInputStream in = new ByteArrayInputStream(data, startOffset, dataLength);
            gzip = new GZIPInputStream((InputStream)in, 8192);
            byte[] buf = new byte[initBufSize];
            int offset = 0;
            while ((readNum = gzip.read(buf, offset, 8192)) != -1) {
                if ((offset += readNum) + 8192 <= buf.length - 1) continue;
                buf = Arrays.copyOf(buf, buf.length * 2);
            }
            byte[] byArray = Arrays.copyOf(buf, offset);
            return byArray;
        }
    }

    public static byte[] snappyCompress(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return null;
        }
        return Snappy.compress((byte[])data);
    }

    public static byte[] snappyDecompress(byte[] data, int startOffset, int dataLength) throws IOException {
        int needSize = Snappy.uncompressedLength((byte[])data, (int)startOffset, (int)dataLength);
        byte[] result = new byte[needSize];
        Snappy.uncompress((byte[])data, (int)startOffset, (int)dataLength, (byte[])result, (int)0);
        return result;
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null || buffer.remaining() == 0) {
            return new byte[0];
        }
        int remainBytes = buffer.remaining();
        byte[] value = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            System.arraycopy(buffer.array(), buffer.arrayOffset(), value, 0, remainBytes);
        } else {
            buffer.get(value, 0, remainBytes);
        }
        return value;
    }

    public static double div(double d1, double d2) {
        return d2 != 0.0 ? d1 / d2 : 0.0;
    }

    public static String nowToStr() {
        return StringUtil.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static <K, V> V getMapValue(Map<K, V> map, K k, V defaultV) {
        if (map == null) {
            return defaultV;
        }
        V v = map.get(k);
        return v != null ? v : defaultV;
    }
}

