/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.FlexVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class FlexVolumeSourceFluentImpl<A extends FlexVolumeSourceFluent<A>>
extends BaseFluent<A>
implements FlexVolumeSourceFluent<A> {
    private String driver;
    private String fsType;
    private Map<String, String> options;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private Map<String, Object> additionalProperties;

    public FlexVolumeSourceFluentImpl() {
    }

    public FlexVolumeSourceFluentImpl(FlexVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withOptions(instance.getOptions());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    @Override
    public Boolean hasOptions() {
        return this.options != null;
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public FlexVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexVolumeSourceFluentImpl that = (FlexVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.options, this.readOnly, this.secretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<FlexVolumeSourceFluent.SecretRefNested<N>>
    implements FlexVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)FlexVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

