/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.simplemvc;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.master.web.simplemvc.Action;
import org.apache.inlong.tubemq.server.master.web.simplemvc.ControlTool;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;
import org.apache.inlong.tubemq.server.master.web.simplemvc.TemplateEngine;
import org.apache.inlong.tubemq.server.master.web.simplemvc.VelocityTemplateEngine;
import org.apache.inlong.tubemq.server.master.web.simplemvc.conf.WebConfig;
import org.apache.inlong.tubemq.server.master.web.simplemvc.exception.TemplateNotFoundException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.support.GenericXmlApplicationContext;

public class RequestDispatcher {
    private static final String TYPE_LAYOUT = "layout";
    private static final String TYPE_SCREEN = "screen";
    private static final String TYPE_CONTROL = "control";
    private static final String SCREEN_PLACEHOLDER = "screen_placeholder";
    private final WebConfig config;
    private final TemplateEngine engine;
    private final HashMap<String, Action> actions = new HashMap();
    private final HashMap<String, String> templates = new HashMap();
    private final ThreadLocal<ControlTool> controlTools = new ThreadLocal();
    private GenericXmlApplicationContext applicationContext;

    public RequestDispatcher(WebConfig config) {
        this.config = config;
        this.engine = new VelocityTemplateEngine(config);
    }

    private static String getFileExtName(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length() - 1) {
            return filename.substring(dot);
        }
        return filename;
    }

    public void init() throws Exception {
        this.engine.init();
        this.loadActions();
        this.loadTemplates();
    }

    public void processRequest(RequestContext context) throws Exception {
        for (Map.Entry<String, Object> entry : this.config.getTools().entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        ControlTool control = this.controlTools.get();
        if (control == null) {
            control = new ControlTool(this);
            this.controlTools.set(control);
        }
        control.setRequestContext(context);
        context.put(TYPE_CONTROL, control);
        this.executeTarget(context, context.getTarget(), TYPE_SCREEN);
        this.executeTarget(context, context.getTarget(), TYPE_LAYOUT);
    }

    public void executeTarget(RequestContext context, String target, String type) throws Exception {
        String targetKey = this.getActionKey(type, target);
        if (this.actions.containsKey(targetKey)) {
            this.actions.get(targetKey).execute(context);
            if (".do".equals(context.requestType())) {
                context.getResp().setStatus(200);
                return;
            }
        }
        String templatePath = this.getTemplateName(type, target);
        if (TYPE_SCREEN.equals(type)) {
            if (context.isRedirected()) {
                if (TStringUtils.isNotEmpty((String)context.getRedirectTarget())) {
                    context.setTarget(context.getRedirectTarget());
                    context.setRedirectTarget(null);
                    context.setRedirectLocation(null);
                    this.executeTarget(context, context.getTarget(), type);
                } else {
                    context.getResp().sendRedirect(context.getRedirectLocation());
                }
            } else {
                if (!this.templates.containsKey(templatePath)) {
                    throw new TemplateNotFoundException(new StringBuilder(256).append("Invalid ").append(type).append(" template path:").append(templatePath).toString());
                }
                context.put(SCREEN_PLACEHOLDER, this.engine.renderTemplate(templatePath, context));
            }
        } else {
            String realTargetKey;
            String realTemplatePath = templatePath;
            if (!this.templates.containsKey(templatePath) && TYPE_LAYOUT.equals(type)) {
                realTemplatePath = this.getLayout(target);
            }
            if (realTemplatePath == null) {
                throw new TemplateNotFoundException(new StringBuilder(256).append("Invalid ").append(type).append(" template path:").append(templatePath).toString());
            }
            if (!realTemplatePath.equals(templatePath) && this.actions.containsKey(realTargetKey = realTemplatePath.substring(0, realTemplatePath.indexOf(".vm")))) {
                this.actions.get(realTargetKey).execute(context);
            }
            this.engine.renderTemplate(realTemplatePath, context, context.getResp().getWriter());
        }
    }

    public String getActionKey(String type, String target) {
        return new StringBuilder(256).append(type).append("/").append(target).toString();
    }

    public String getTemplateName(String type, String target) {
        return new StringBuilder(256).append(type).append("/").append(target).append(".vm").toString();
    }

    public String getLayout(String target) {
        String layout = null;
        String[] targetPaths = target.split("/");
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = targetPaths.length - 1; i >= 0; --i) {
            pathBuilder.append(TYPE_LAYOUT);
            pathBuilder.append("/");
            for (int j = 0; j < i; ++j) {
                pathBuilder.append(targetPaths[j]);
                pathBuilder.append("/");
            }
            pathBuilder.append("default.vm");
            String path = pathBuilder.toString();
            if (this.templates.containsKey(path)) {
                layout = path;
                break;
            }
            pathBuilder.delete(0, pathBuilder.length());
        }
        return layout;
    }

    private void loadActions() throws Exception {
        String actionPath = this.config.getActionPackage();
        if (this.config.getActions().size() != 0) {
            for (Map.Entry<String, Action> entry : this.config.getActions().entrySet()) {
                String actionKey = entry.getKey().substring(actionPath.length() + 1).replaceAll("\\.", "/");
                this.actions.put(TStringUtils.toCamelCase((String)actionKey), entry.getValue());
            }
        } else {
            if (this.config.isSpringSupported()) {
                String[] resources = new String[this.config.getBeanFilePathList().size()];
                for (int i = 0; i < this.config.getBeanFilePathList().size(); ++i) {
                    resources[i] = this.config.getBeanFilePathList().get(i);
                }
                this.applicationContext = new GenericXmlApplicationContext();
                ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
                AutowiredAnnotationBeanPostProcessor autowiredProcessor = new AutowiredAnnotationBeanPostProcessor();
                autowiredProcessor.setBeanFactory((BeanFactory)beanFactory);
                beanFactory.addBeanPostProcessor((BeanPostProcessor)autowiredProcessor);
                CommonAnnotationBeanPostProcessor commonProcessor = new CommonAnnotationBeanPostProcessor();
                commonProcessor.setBeanFactory((BeanFactory)beanFactory);
                beanFactory.addBeanPostProcessor((BeanPostProcessor)commonProcessor);
                RequiredAnnotationBeanPostProcessor requiredProcessor = new RequiredAnnotationBeanPostProcessor();
                requiredProcessor.setBeanFactory((BeanFactory)beanFactory);
                beanFactory.addBeanPostProcessor((BeanPostProcessor)requiredProcessor);
                this.applicationContext.load(resources);
            }
            List<Class> actionClasses = this.getActionClasses(actionPath);
            for (Class clazz : actionClasses) {
                String actionKey = clazz.getName().substring(actionPath.length() + 1).replaceAll("\\.", "/");
                Action action = null;
                action = this.config.isSpringSupported() ? (Action)this.applicationContext.getBeanFactory().autowire(clazz, 1, true) : (Action)clazz.newInstance();
                this.actions.put(TStringUtils.toCamelCase((String)actionKey), action);
            }
        }
    }

    private void loadTemplates() throws Exception {
        String templatePath = this.config.getTemplatePath();
        List<File> fileList = this.getFileList(templatePath, ".vm");
        for (File file : fileList) {
            String filePath = file.toURI().getPath();
            String relativePath = filePath.substring(templatePath.length(), filePath.length());
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            this.templates.put(relativePath, relativePath);
        }
    }

    private List<Class> getActionClasses(String packageName) throws Exception {
        ArrayList<Class> classList = new ArrayList<Class>();
        String path = packageName.replaceAll("\\.", "/");
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url == null) {
            return Collections.emptyList();
        }
        List<File> actionClassFileList = this.getFileList(url.getFile(), ".class");
        for (File f : actionClassFileList) {
            String pathStr = f.getPath().replaceAll("/|\\\\", ".");
            Class<?> clazz = Class.forName(pathStr.substring(pathStr.indexOf(packageName), pathStr.length() - 6));
            if (!Action.class.isAssignableFrom(clazz)) continue;
            classList.add(clazz);
        }
        return classList;
    }

    private List<File> getFileList(String directory, String type) throws Exception {
        File file = new File(directory);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getFile(file, fileList, type);
        return fileList;
    }

    private void getFile(File file, List<File> fileList, String type) throws Exception {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    this.getFile(f, fileList, type);
                }
            }
        } else if (".*".equals(type) || type.equals(RequestDispatcher.getFileExtName(file.getPath()))) {
            fileList.add(file);
        }
    }
}

