/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeproducer;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.cluster.ProducerInfo;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;

public class ProducerInfoHolder {
    final ConcurrentHashMap<String, ProducerInfo> producerInfoMap = new ConcurrentHashMap();

    public ProducerInfo getProducerInfo(String producerId) {
        return this.producerInfoMap.get(producerId);
    }

    public void setProducerInfo(String producerId, Set<String> topicSet, String host, boolean overTLS) {
        if (this.producerInfoMap.put(producerId, new ProducerInfo(producerId, topicSet, host, overTLS)) == null) {
            MasterSrvStatsHolder.incProducerCnt();
        }
    }

    public void updateProducerInfo(String producerId, Set<String> topicSet, String host, boolean overTLS) {
        ProducerInfo newProducer = new ProducerInfo(producerId, topicSet, host, overTLS);
        ProducerInfo curProducer = this.producerInfoMap.get(producerId);
        if (!newProducer.equals((Object)curProducer)) {
            this.producerInfoMap.put(producerId, newProducer);
        }
    }

    public ProducerInfo removeProducer(String producerId, boolean isTimeout) {
        ProducerInfo info = this.producerInfoMap.remove(producerId);
        if (info != null) {
            MasterSrvStatsHolder.decProducerCnt(isTimeout);
        }
        return info;
    }

    public void clear() {
        this.producerInfoMap.clear();
    }
}

