/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.utils.ClientSyncInfo;
import org.apache.inlong.tubemq.server.master.nodemanage.nodeconsumer.ConsumeType;

public class ConsumerInfo
implements Comparable<ConsumerInfo>,
Serializable {
    private static final long serialVersionUID = 3095734962491009712L;
    private final String consumerId;
    private final String consumerViewInfo;
    private final ConsumeType consumeType;
    private final String group;
    private final Set<String> topicSet;
    private final Map<String, TreeSet<String>> topicConditions;
    private String addrRcvFrom;
    private boolean overTLS = false;
    private long startTime = -2L;
    private int sourceCount = -2;
    private int nodeId = -2;
    private String sessionKey = "";
    private boolean selectedBig = true;
    private Map<String, Long> requiredPartition;
    private long csmFromMaxOffsetCtrlId = -2L;
    private long lstAssignedTime = -2L;
    private long usedTopicMetaInfoId = -2L;

    public ConsumerInfo(String consumerId, boolean overTLS, String group, Set<String> topicSet, Map<String, TreeSet<String>> topicConditions, ConsumeType consumeType, String sessionKey, long startTime, int sourceCount, boolean selectedBig, Map<String, Long> requiredPartition, String msgRcvFrom) {
        this.group = group;
        this.consumeType = consumeType;
        this.consumerId = consumerId;
        this.addrRcvFrom = msgRcvFrom;
        this.overTLS = overTLS;
        this.topicSet = topicSet;
        this.topicConditions = topicConditions == null ? new HashMap<String, TreeSet<String>>() : topicConditions;
        this.sessionKey = sessionKey;
        this.selectedBig = selectedBig;
        this.startTime = startTime;
        this.sourceCount = sourceCount;
        this.requiredPartition = requiredPartition;
        this.consumerViewInfo = this.toString();
    }

    public ConsumerInfo(String consumerId, boolean overTLS, String group, ConsumeType consumeType, int sourceCount, int nodeId, Set<String> topicSet, Map<String, TreeSet<String>> topicConditions, long curCsmCtrlId, ClientSyncInfo syncInfo, String msgRcvFrom) {
        this.group = group;
        this.consumeType = consumeType;
        this.consumerId = consumerId;
        this.addrRcvFrom = msgRcvFrom;
        this.overTLS = overTLS;
        this.topicSet = topicSet;
        this.topicConditions = topicConditions == null ? new HashMap<String, TreeSet<String>>() : topicConditions;
        this.sourceCount = sourceCount;
        this.nodeId = nodeId;
        this.startTime = System.currentTimeMillis();
        if (curCsmCtrlId != -2L) {
            this.csmFromMaxOffsetCtrlId = curCsmCtrlId;
        }
        this.updClientReportInfo(curCsmCtrlId, syncInfo.getLstAssignedTime(), syncInfo.getTopicMetaInfoId());
        this.consumerViewInfo = this.toString();
    }

    public void updCurConsumerInfo(ConsumerInfo inCsmInfo) {
        if (inCsmInfo.getConsumeType() != ConsumeType.CONSUME_CLIENT_REB) {
            return;
        }
        this.overTLS = inCsmInfo.overTLS;
        this.addrRcvFrom = inCsmInfo.addrRcvFrom;
        this.nodeId = inCsmInfo.getNodeId();
        this.updClientReportInfo(inCsmInfo.getCsmFromMaxOffsetCtrlId(), inCsmInfo.getLstAssignedTime(), inCsmInfo.getUsedTopicMetaInfoId());
    }

    public void updClientReportInfo(long lstCsmCtrlId, long lastAssignedTime, long usedTopicMetaInfoId) {
        if (lstCsmCtrlId >= 0L && lstCsmCtrlId != this.csmFromMaxOffsetCtrlId) {
            this.csmFromMaxOffsetCtrlId = lstCsmCtrlId;
        }
        if (lastAssignedTime != -2L && this.lstAssignedTime != lastAssignedTime) {
            this.lstAssignedTime = lastAssignedTime;
        }
        if (usedTopicMetaInfoId != -2L && this.usedTopicMetaInfoId != usedTopicMetaInfoId) {
            this.usedTopicMetaInfoId = usedTopicMetaInfoId;
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder(512).append(this.consumerId).append("@").append(this.group).append(":");
        int count = 0;
        for (String topicItem : this.topicSet) {
            if (count++ > 0) {
                sBuilder.append(",");
            }
            sBuilder.append(topicItem);
        }
        sBuilder.append("@overTLS=").append(this.overTLS);
        return sBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerInfo)) {
            return false;
        }
        ConsumerInfo info = (ConsumerInfo)obj;
        return this.consumerId.equals(info.getConsumerId());
    }

    @Override
    public int compareTo(ConsumerInfo o) {
        if (!this.consumerId.equals(o.consumerId)) {
            return this.consumerId.compareTo(o.consumerId);
        }
        if (!this.group.equals(o.group)) {
            return this.group.compareTo(o.group);
        }
        return 0;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getGroupName() {
        return this.group;
    }

    public Set<String> getTopicSet() {
        return this.topicSet;
    }

    public Map<String, TreeSet<String>> getTopicConditions() {
        return this.topicConditions;
    }

    public String getAddrRcvFrom() {
        return this.addrRcvFrom;
    }

    public boolean isOverTLS() {
        return this.overTLS;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public long getCsmFromMaxOffsetCtrlId() {
        return this.csmFromMaxOffsetCtrlId;
    }

    public boolean isRequireBound() {
        return this.consumeType == ConsumeType.CONSUME_BAND;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public Map<String, Long> getRequiredPartition() {
        return this.requiredPartition;
    }

    public ConsumeType getConsumeType() {
        return this.consumeType;
    }

    public boolean isSelectedBig() {
        return this.selectedBig;
    }

    public String getConsumerViewInfo() {
        return this.consumerViewInfo;
    }

    public long getLstAssignedTime() {
        return this.lstAssignedTime;
    }

    public long getUsedTopicMetaInfoId() {
        return this.usedTopicMetaInfoId;
    }

    public Tuple2<String, Boolean> getConsumerIdAndTlsInfoTuple() {
        return new Tuple2((Object)this.consumerId, (Object)this.overTLS);
    }
}

