/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.ConcurrentHashSet;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerTopicInfoView;

public class BrokerPSInfoHolder {
    private final ConcurrentHashSet<Integer> enablePubBrokerIdSet = new ConcurrentHashSet();
    private final ConcurrentHashSet<Integer> enableSubBrokerIdSet = new ConcurrentHashSet();
    private final BrokerTopicInfoView subTopicInfoView = new BrokerTopicInfoView();
    private final BrokerTopicInfoView pubTopicInfoView = new BrokerTopicInfoView();

    public void rmvBrokerAllPushedInfo(int brokerId) {
        this.enablePubBrokerIdSet.remove((Object)brokerId);
        this.enableSubBrokerIdSet.remove((Object)brokerId);
        this.subTopicInfoView.rmvBrokerTopicInfo(brokerId);
        this.pubTopicInfoView.rmvBrokerTopicInfo(brokerId);
    }

    public void iniBrokerConfigInfo(int brokerId, ManageStatus mngStatus, Map<String, TopicInfo> topicInfoMap) {
        this.updBrokerMangeStatus(brokerId, mngStatus);
        if (topicInfoMap == null) {
            return;
        }
        this.subTopicInfoView.updBrokerTopicConfInfo(brokerId, topicInfoMap);
        this.pubTopicInfoView.updBrokerTopicConfInfo(brokerId, topicInfoMap);
    }

    public void updBrokerMangeStatus(int brokerId, ManageStatus mngStatus) {
        if (mngStatus.isAcceptPublish()) {
            this.enablePubBrokerIdSet.add((Object)brokerId);
        } else {
            this.enablePubBrokerIdSet.remove((Object)brokerId);
        }
        if (mngStatus.isAcceptSubscribe()) {
            this.enableSubBrokerIdSet.add((Object)brokerId);
        } else {
            this.enableSubBrokerIdSet.remove((Object)brokerId);
        }
    }

    public void getBrokerPubStatus(int brokerId, Tuple2<Boolean, Boolean> result) {
        result.setF0AndF1((Object)this.enablePubBrokerIdSet.contains((Object)brokerId), (Object)this.enableSubBrokerIdSet.contains((Object)brokerId));
    }

    public boolean updBrokerSubTopicConfInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        if (topicInfoMap == null) {
            return true;
        }
        this.subTopicInfoView.updBrokerTopicConfInfo(brokerId, topicInfoMap);
        return this.pubTopicInfoView.fastUpdBrokerTopicConfInfo(brokerId, topicInfoMap);
    }

    public void updBrokerPubTopicConfInfo(int brokerId, Map<String, TopicInfo> topicInfoMap) {
        if (topicInfoMap == null) {
            return;
        }
        this.pubTopicInfoView.updBrokerTopicConfInfo(brokerId, topicInfoMap);
    }

    public int getTopicMaxSubBrokerCnt(Set<String> topicSet) {
        return this.subTopicInfoView.getMaxTopicBrokerCnt(topicSet, (Set<Integer>)this.enableSubBrokerIdSet);
    }

    public Map<String, Partition> getAcceptSubParts(Set<String> topicSet) {
        return this.subTopicInfoView.getAcceptSubParts(topicSet, (Set<Integer>)this.enableSubBrokerIdSet);
    }

    public List<Partition> getAcceptSubParts(String topic) {
        return this.subTopicInfoView.getAcceptSubParts(topic, (Set<Integer>)this.enableSubBrokerIdSet);
    }

    public void getBrokerSubPushedTopicInfo(int brokerId, String topic, Tuple2<Boolean, TopicInfo> result) {
        result.setF0AndF1((Object)this.enableSubBrokerIdSet.contains((Object)brokerId), (Object)this.subTopicInfoView.getBrokerPushedTopicInfo(brokerId, topic));
    }

    public Map<String, String> getAcceptPubPartInfo(Map<String, Integer> topicSizeMap) {
        return this.pubTopicInfoView.getAcceptPubPartInfo(topicSizeMap, (Set<Integer>)this.enablePubBrokerIdSet);
    }

    public void getBrokerPubPushedTopicInfo(int brokerId, String topic, Tuple3<Boolean, Boolean, TopicInfo> result) {
        result.setFieldsValue((Object)this.enablePubBrokerIdSet.contains((Object)brokerId), (Object)this.enableSubBrokerIdSet.contains((Object)brokerId), (Object)this.pubTopicInfoView.getBrokerPushedTopicInfo(brokerId, topic));
    }

    public void getPubBrokerPushedTopicInfo(int brokerId, Tuple3<Boolean, Boolean, List<TopicInfo>> result) {
        result.setFieldsValue((Object)this.enablePubBrokerIdSet.contains((Object)brokerId), (Object)this.enableSubBrokerIdSet.contains((Object)brokerId), this.pubTopicInfoView.getBrokerPushedTopicInfo(brokerId));
    }
}

