/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.zkimpl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.common.zookeeper.ZKUtil;
import org.apache.inlong.tubemq.server.common.zookeeper.ZooKeeperWatcher;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsConsumeCtrlMapperImpl;
import org.apache.zookeeper.KeeperException;

public class ZKConsumeCtrlMapperImpl
extends AbsConsumeCtrlMapperImpl {
    private final ZooKeeperWatcher zkWatcher;
    private final String csmCtrlRootDir;

    public ZKConsumeCtrlMapperImpl(String metaNodePrefix, ZooKeeperWatcher zkWatcher, StringBuilder strBuff) {
        this.zkWatcher = zkWatcher;
        this.csmCtrlRootDir = strBuff.append(metaNodePrefix).append("/").append("consumeCtrlConfig").toString();
        strBuff.delete(0, strBuff.length());
    }

    @Override
    public void close() {
        this.clearCachedData();
        logger.info("[ZK Impl] close consume control configure failure finished!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        logger.info("[ZK Impl] load consume control configure start...");
        List<String> childNodes = ZKUtil.getChildren(this.zkWatcher, this.csmCtrlRootDir);
        if (childNodes == null) {
            logger.info("[ZK Impl] Not found consume control configure from ZooKeeper");
            return;
        }
        Gson gson = new Gson();
        Type type = new TypeToken<GroupConsumeCtrlEntity>(){}.getType();
        for (String itemKey : childNodes) {
            String recordStr;
            if (TStringUtils.isEmpty((String)itemKey)) continue;
            try {
                recordStr = ZKUtil.readDataMaybeNull(this.zkWatcher, strBuff.append(this.csmCtrlRootDir).append("/").append(itemKey).toString());
                strBuff.delete(0, strBuff.length());
            }
            catch (KeeperException e) {
                BrokerSrvStatsHolder.incZKExcCnt();
                logger.error("KeeperException during load consume control configure from ZooKeeper", (Throwable)e);
                throw new LoadMetaException(e.getMessage());
            }
            if (recordStr == null) continue;
            this.putRecord2Caches((GroupConsumeCtrlEntity)gson.fromJson(recordStr, type));
            ++totalCnt;
        }
        logger.info(strBuff.append("[ZK Impl] loaded ").append(totalCnt).append(" consume control configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(GroupConsumeCtrlEntity entity, StringBuilder strBuff, ProcessResult result) {
        String entityStr = entity.toString();
        String confNode = strBuff.append(this.csmCtrlRootDir).append("/").append(entity.getRecordKey()).toString();
        strBuff.delete(0, strBuff.length());
        try {
            ZKUtil.updatePersistentPath(this.zkWatcher, confNode, entityStr);
        }
        catch (Throwable t) {
            BrokerSrvStatsHolder.incZKExcCnt();
            logger.error("[ZK Impl] put consume control configure failure ", t);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put consume control configure failure: ").append(t.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(String recordKey, StringBuilder strBuff) {
        ZKUtil.delZNode(this.zkWatcher, strBuff.append(this.csmCtrlRootDir).append("/").append(recordKey).toString());
        strBuff.delete(0, strBuff.length());
        return true;
    }
}

