/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.mapper.ClusterConfigMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsClusterConfigMapperImpl
implements ClusterConfigMapper {
    protected static final Logger logger = LoggerFactory.getLogger(AbsClusterConfigMapperImpl.class);
    private final Map<String, ClusterSettingEntity> metaDataCache = new ConcurrentHashMap<String, ClusterSettingEntity>();

    @Override
    public boolean addUpdClusterConfig(ClusterSettingEntity entity, StringBuilder strBuff, ProcessResult result) {
        ClusterSettingEntity newEntity;
        ClusterSettingEntity curEntity = this.metaDataCache.get(entity.getRecordKey());
        if (curEntity == null) {
            newEntity = entity.clone();
        } else {
            newEntity = curEntity.clone();
            newEntity.updBaseModifyInfo(entity);
            if (!newEntity.updModifyInfo(entity.getDataVerId(), entity.getBrokerPort(), entity.getBrokerTLSPort(), entity.getBrokerWebPort(), entity.getMaxMsgSizeInMB(), entity.getQryPriorityId(), entity.getGloFlowCtrlStatus(), entity.getGloFlowCtrlRuleCnt(), entity.getGloFlowCtrlRuleInfo(), entity.getClsDefTopicProps())) {
                result.setFailResult(DataOpErrCode.DERR_UNCHANGED.getCode(), "Cluster configure not changed!");
                return result.isSuccess();
            }
        }
        if (!WebParameterUtils.isValidPortsSet(newEntity.getBrokerPort(), newEntity.getBrokerTLSPort(), newEntity.getBrokerWebPort(), strBuff, result)) {
            return result.isSuccess();
        }
        if (this.putConfig2Persistent(newEntity, strBuff, result)) {
            this.metaDataCache.put(newEntity.getRecordKey(), entity);
        }
        return result.isSuccess();
    }

    @Override
    public boolean delClusterConfig(StringBuilder strBuff, ProcessResult result) {
        ClusterSettingEntity curEntity = this.metaDataCache.get("default_cluster_config");
        if (curEntity == null) {
            result.setSuccResult(null);
            return true;
        }
        this.delConfigFromPersistent(strBuff, "default_cluster_config");
        this.metaDataCache.remove("default_cluster_config");
        result.setSuccResult(null);
        return true;
    }

    @Override
    public ClusterSettingEntity getClusterConfig() {
        return this.metaDataCache.get("default_cluster_config");
    }

    protected void clearCachedData() {
        this.metaDataCache.clear();
    }

    protected void putRecord2Caches(ClusterSettingEntity entity) {
        this.metaDataCache.put(entity.getRecordKey(), entity);
    }

    protected abstract boolean putConfig2Persistent(ClusterSettingEntity var1, StringBuilder var2, ProcessResult var3);

    protected abstract boolean delConfigFromPersistent(StringBuilder var1, String var2);
}

