/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.KeyBuilderUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbTopicConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;

public class TopicDeployEntity
extends BaseEntity
implements Cloneable {
    private String recordKey = "";
    private String topicName = "";
    private int brokerId = -2;
    private TopicStatus deployStatus = TopicStatus.STATUS_TOPIC_UNDEFINED;
    private TopicPropGroup topicProps = new TopicPropGroup();
    private String brokerIp = "";
    private int brokerPort = -2;
    private String brokerAddress = "";
    private int topicNameId = -2;

    public TopicDeployEntity() {
    }

    public TopicDeployEntity(BaseEntity opInfoEntity, int brokerId, String topicName) {
        super(opInfoEntity);
        this.brokerId = brokerId;
        this.topicName = topicName;
        this.recordKey = KeyBuilderUtils.buildTopicConfRecKey((int)brokerId, (String)topicName);
    }

    public TopicDeployEntity(BaseEntity opInfoEntity, int brokerId, String topicName, TopicPropGroup topicProps) {
        super(opInfoEntity);
        this.brokerId = brokerId;
        this.topicName = topicName;
        this.recordKey = KeyBuilderUtils.buildTopicConfRecKey((int)brokerId, (String)topicName);
        this.topicProps.updModifyInfo(topicProps);
    }

    public TopicDeployEntity(BdbTopicConfEntity bdbEntity) {
        super(bdbEntity.getDataVerId(), bdbEntity.getCreateUser(), bdbEntity.getCreateDate(), bdbEntity.getModifyUser(), bdbEntity.getModifyDate());
        this.setTopicDeployInfo(bdbEntity.getBrokerId(), bdbEntity.getBrokerIp(), bdbEntity.getBrokerPort(), bdbEntity.getTopicName());
        this.topicNameId = bdbEntity.getTopicId();
        this.deployStatus = TopicStatus.valueOf(bdbEntity.getTopicStatusId());
        this.topicProps = new TopicPropGroup(bdbEntity.getNumTopicStores(), bdbEntity.getNumPartitions(), bdbEntity.getUnflushThreshold(), bdbEntity.getUnflushInterval(), bdbEntity.getUnflushDataHold(), bdbEntity.getMemCacheMsgSizeInMB(), bdbEntity.getMemCacheMsgCntInK(), bdbEntity.getMemCacheFlushIntvl(), bdbEntity.getAcceptPublish(), bdbEntity.getAcceptSubscribe(), bdbEntity.getDeletePolicy(), bdbEntity.getDataStoreType(), bdbEntity.getDataPath());
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbTopicConfEntity buildBdbTopicConfEntity() {
        BdbTopicConfEntity bdbEntity = new BdbTopicConfEntity(this.brokerId, this.brokerIp, this.brokerPort, this.topicName, this.topicProps.getNumPartitions(), this.topicProps.getUnflushThreshold(), this.topicProps.getUnflushInterval(), "", this.topicProps.getDeletePolicy(), this.topicProps.isAcceptPublish(), this.topicProps.isAcceptSubscribe(), this.topicProps.getNumTopicStores(), this.getAttributes(), this.getCreateUser(), this.getCreateDate(), this.getModifyUser(), this.getModifyDate());
        bdbEntity.setDataVerId(this.getDataVerId());
        bdbEntity.setTopicId(this.topicNameId);
        bdbEntity.setTopicStatusId(this.deployStatus.getCode());
        bdbEntity.setDataStore(this.topicProps.getDataStoreType(), this.topicProps.getDataPath());
        bdbEntity.setNumTopicStores(this.topicProps.getNumTopicStores());
        bdbEntity.setMemCacheMsgSizeInMB(this.topicProps.getMemCacheMsgSizeInMB());
        bdbEntity.setMemCacheMsgCntInK(this.topicProps.getMemCacheMsgCntInK());
        bdbEntity.setMemCacheFlushIntvl(this.topicProps.getMemCacheFlushIntvl());
        bdbEntity.setUnflushDataHold(this.topicProps.getUnflushDataHold());
        return bdbEntity;
    }

    private void setTopicDeployInfo(int brokerId, String brokerIp, int brokerPort, String topicName) {
        this.brokerId = brokerId;
        this.brokerIp = brokerIp;
        this.brokerPort = brokerPort;
        this.topicName = topicName;
        this.recordKey = KeyBuilderUtils.buildTopicConfRecKey((int)brokerId, (String)topicName);
        this.brokerAddress = KeyBuilderUtils.buildAddressInfo((String)brokerIp, (int)brokerPort);
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public String getBrokerIp() {
        return this.brokerIp;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public String getBrokerAddress() {
        return this.brokerAddress;
    }

    public TopicPropGroup getTopicProps() {
        return this.topicProps;
    }

    public void setTopicProps(TopicPropGroup topicProps) {
        this.topicProps = topicProps;
    }

    public int getNumTopicStores() {
        return this.topicProps.getNumTopicStores();
    }

    public int getNumPartitions() {
        return this.topicProps.getNumPartitions();
    }

    public boolean isAcceptPublish() {
        return this.topicProps.isAcceptPublish();
    }

    public boolean isAcceptSubscribe() {
        return this.topicProps.isAcceptSubscribe();
    }

    public int getTopicId() {
        return this.topicNameId;
    }

    public void setTopicId(int topicId) {
        this.topicNameId = topicId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public TopicStatus getTopicStatus() {
        return this.deployStatus;
    }

    public void setTopicStatusId(int topicStatusId) {
        this.deployStatus = TopicStatus.valueOf(topicStatusId);
    }

    public boolean isInRemoving() {
        return this.deployStatus == TopicStatus.STATUS_TOPIC_SOFT_REMOVE || this.deployStatus == TopicStatus.STATUS_TOPIC_HARD_REMOVE;
    }

    public int getTopicStatusId() {
        return this.deployStatus.getCode();
    }

    public boolean isValidTopicStatus() {
        return this.deployStatus == TopicStatus.STATUS_TOPIC_OK;
    }

    public TopicStatus getDeployStatus() {
        return this.deployStatus;
    }

    public void setDeployStatus(TopicStatus deployStatus) {
        this.deployStatus = deployStatus;
    }

    public boolean updModifyInfo(long dataVerId, int topicNameId, int brokerPort, String brokerIp, TopicStatus deployStatus, TopicPropGroup topicProps) {
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (topicNameId != -2 && this.topicNameId != topicNameId) {
            changed = true;
            this.topicNameId = topicNameId;
        }
        if (brokerPort != -2 && this.brokerPort != brokerPort) {
            changed = true;
            this.brokerPort = brokerPort;
        }
        if (TStringUtils.isNotBlank((String)brokerIp) && !this.brokerIp.equals(brokerIp)) {
            changed = true;
            this.brokerIp = brokerIp;
        }
        if (deployStatus != null && deployStatus != TopicStatus.STATUS_TOPIC_UNDEFINED && this.deployStatus != deployStatus) {
            changed = true;
            this.deployStatus = deployStatus;
        }
        if (topicProps != null && !topicProps.isDataEquals(this.topicProps) && this.topicProps.updModifyInfo(topicProps)) {
            changed = true;
        }
        if (changed) {
            this.brokerAddress = KeyBuilderUtils.buildAddressInfo((String)this.brokerIp, (int)this.brokerPort);
            this.updSerialId();
        }
        return changed;
    }

    public boolean isMatched(TopicDeployEntity target, boolean fullMatch) {
        if (target == null) {
            return true;
        }
        if (fullMatch && !super.isMatched(target)) {
            return false;
        }
        return !(target.getBrokerId() != -2 && target.getBrokerId() != this.brokerId || target.getBrokerPort() != -2 && target.getBrokerPort() != this.brokerPort || target.getTopicId() != -2 && target.getTopicId() != this.topicNameId || !TStringUtils.isBlank((String)target.getTopicName()) && !target.getTopicName().equals(this.topicName) || !TStringUtils.isBlank((String)target.getBrokerIp()) && !target.getBrokerIp().equals(this.brokerIp) || !this.topicProps.isMatched(target.topicProps) || target.getTopicStatus() != TopicStatus.STATUS_TOPIC_UNDEFINED && target.getTopicStatus() != this.deployStatus);
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuilder, boolean isLongName, boolean fullFormat) {
        if (isLongName) {
            sBuilder.append("{\"topicName\":\"").append(this.topicName).append("\"").append(",\"brokerId\":").append(this.brokerId).append(",\"topicNameId\":").append(this.topicNameId).append(",\"brokerIp\":\"").append(this.brokerIp).append("\"").append(",\"brokerPort\":").append(this.brokerPort).append(",\"topicStatusId\":").append(this.deployStatus.getCode());
        } else {
            sBuilder.append("{\"topic\":\"").append(this.topicName).append("\"").append(",\"brkId\":").append(this.brokerId).append(",\"topicId\":").append(this.topicNameId).append(",\"bIp\":\"").append(this.brokerIp).append("\"").append(",\"bPort\":").append(this.brokerPort).append(",\"tStsId\":").append(this.deployStatus.getCode());
        }
        this.topicProps.toWebJsonStr(sBuilder, isLongName);
        super.toWebJsonStr(sBuilder, isLongName);
        if (fullFormat) {
            sBuilder.append("}");
        }
        return sBuilder;
    }

    public boolean isDataEquals(TopicDeployEntity other) {
        return super.isDataEquals(other) && this.brokerId == other.brokerId && this.brokerPort == other.brokerPort && this.topicNameId == other.topicNameId && this.recordKey.equals(other.recordKey) && this.topicName.equals(other.topicName) && Objects.equals(this.brokerIp, other.brokerIp) && Objects.equals(this.brokerAddress, other.brokerAddress) && this.deployStatus == other.deployStatus && Objects.equals(this.topicProps, other.topicProps);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicDeployEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicDeployEntity that = (TopicDeployEntity)o;
        return this.isDataEquals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.recordKey, this.topicName, this.brokerId, this.brokerIp, this.brokerPort, this.brokerAddress, this.topicNameId, this.deployStatus, this.topicProps});
    }

    @Override
    public TopicDeployEntity clone() {
        TopicDeployEntity copy = (TopicDeployEntity)super.clone();
        if (copy.topicProps != null) {
            copy.topicProps = this.getTopicProps().clone();
        }
        copy.setDeployStatus(this.getDeployStatus());
        return copy;
    }
}

