/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.statusdef;

public enum StepStatus {
    STEP_STATUS_UNDEFINED(-2, "idle", 0L, 0L),
    STEP_STATUS_LOAD_DATA(1, "load_data", 0L, 0L),
    STEP_STATUS_WAIT_ONLINE(2, "wait_online", 0L, 0L),
    STEP_STATUS_WAIT_SYNC(3, "wait_sync", 0L, 0L),
    STEP_STATUS_WAIT_SUBSCRIBE(4, "wait_sub", 30000L, 15000L),
    STEP_STATUS_WAIT_PUBLISH(5, "wait_pub", 5000L, 0L);

    private final int code;
    private final String description;
    private final long normalDelayDurIdnMs;
    private final long shortDelayDurIdnMs;

    private StepStatus(int code, String description, long normalDelayDurIdnMs, long shortDelayDurIdnMs) {
        this.code = code;
        this.description = description;
        this.normalDelayDurIdnMs = normalDelayDurIdnMs;
        this.shortDelayDurIdnMs = shortDelayDurIdnMs;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public long getNormalDelayDurInMs() {
        return this.normalDelayDurIdnMs;
    }

    public long getShortDelayDurIdnMs() {
        return this.shortDelayDurIdnMs;
    }

    public static StepStatus valueOf(int code) {
        for (StepStatus status : StepStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown broker step status code %s", code));
    }
}

