/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.aaaserver;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.aaaserver.CertificateMasterHandler;
import org.apache.inlong.tubemq.server.common.aaaserver.CertifiedInfo;
import org.apache.inlong.tubemq.server.master.MasterConfig;

public class SimpleCertificateMasterHandler
implements CertificateMasterHandler {
    private final MasterConfig masterConfig;

    public SimpleCertificateMasterHandler(MasterConfig masterConfig) {
        this.masterConfig = masterConfig;
    }

    @Override
    public boolean identityValidBrokerInfo(ClientMaster.MasterCertificateInfo certificateInfo, ProcessResult result) {
        if (!this.masterConfig.isNeedBrokerVisitAuth()) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        if (certificateInfo == null) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        ClientMaster.AuthenticateInfo authInfo = certificateInfo.getAuthInfo();
        if (authInfo == null) {
            result.setFailResult(415, "Illegal value: AuthenticateInfo is null!");
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)authInfo.getUserName())) {
            result.setFailResult(415, "Illegal value: authInfo.userName is Blank!");
            return result.isSuccess();
        }
        String inUserName = authInfo.getUserName().trim();
        if (TStringUtils.isBlank((String)authInfo.getSignature())) {
            result.setFailResult(415, "Illegal value: authInfo.signature is Blank!");
            return result.isSuccess();
        }
        String inSignature = authInfo.getSignature().trim();
        if (!inUserName.equals(this.masterConfig.getVisitName())) {
            result.setFailResult(415, "Illegal value: userName is not equal in authenticateToken!");
            return result.isSuccess();
        }
        if (Math.abs(System.currentTimeMillis() - authInfo.getTimestamp()) > this.masterConfig.getAuthValidTimeStampPeriodMs()) {
            result.setFailResult(415, "Illegal value: timestamp out of effective period in authenticateToken!");
            return result.isSuccess();
        }
        String signature = TStringUtils.getAuthSignature((String)inUserName, (String)this.masterConfig.getVisitPassword(), (long)authInfo.getTimestamp(), (int)authInfo.getNonce());
        if (!inSignature.equals(signature)) {
            result.setFailResult(415, "Illegal value: userName or password is not correct!");
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }

    @Override
    public boolean identityValidUserInfo(ClientMaster.MasterCertificateInfo certificateInfo, boolean isProduce, ProcessResult result) {
        String inUserName = "";
        String authorizedToken = "";
        String othParams = "";
        if (isProduce) {
            if (!this.masterConfig.isStartProduceAuthenticate()) {
                result.setSuccResult((Object)new CertifiedInfo(inUserName, authorizedToken));
                return result.isSuccess();
            }
        } else if (!this.masterConfig.isStartConsumeAuthenticate()) {
            result.setSuccResult((Object)new CertifiedInfo(inUserName, authorizedToken));
            return result.isSuccess();
        }
        if (certificateInfo == null) {
            result.setFailResult(415, "Server required MasterCertificateInfo!");
            return result.isSuccess();
        }
        ClientMaster.AuthenticateInfo authInfo = certificateInfo.getAuthInfo();
        if (authInfo == null) {
            result.setFailResult(415, "Illegal value: AuthenticateInfo is null!");
            return result.isSuccess();
        }
        if (TStringUtils.isBlank((String)authInfo.getUserName())) {
            result.setFailResult(415, "Illegal value: authInfo.userName is Blank!");
            return result.isSuccess();
        }
        inUserName = authInfo.getUserName().trim();
        if (TStringUtils.isNotBlank((String)authInfo.getOthParams())) {
            othParams = authInfo.getOthParams().trim();
        }
        if (TStringUtils.isBlank((String)authInfo.getSignature())) {
            result.setFailResult(415, "Illegal value: authInfo.signature is Blank!");
            return result.isSuccess();
        }
        String inSignature = authInfo.getSignature().trim();
        if (Math.abs(System.currentTimeMillis() - authInfo.getTimestamp()) > this.masterConfig.getAuthValidTimeStampPeriodMs()) {
            result.setFailResult(415, "Illegal value: timestamp out of effective period in authenticateToken!");
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo(inUserName, authorizedToken));
        return result.isSuccess();
    }

    @Override
    public boolean validProducerAuthorizeInfo(String userName, Set<String> topics, String clientIp, ProcessResult result) {
        if (!this.masterConfig.isStartProduceAuthorize()) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }

    @Override
    public boolean validConsumerAuthorizeInfo(String userName, String groupName, Set<String> topics, Map<String, TreeSet<String>> topicConds, String clientIp, ProcessResult result) {
        if (!this.masterConfig.isStartProduceAuthorize()) {
            result.setSuccResult((Object)new CertifiedInfo());
            return result.isSuccess();
        }
        result.setSuccResult((Object)new CertifiedInfo());
        return result.isSuccess();
    }
}

