/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.utils;

import com.google.protobuf.ByteString;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.HashMap;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.utils.MessageFlagUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.broker.stats.TrafficInfo;

public class DataStoreUtils {
    public static final int MAX_MSG_TRANSFER_SIZE = 0x100000;
    public static final int STORE_DATA_PREFX_LEN = 48;
    public static final int STORE_DATA_HEADER_LEN = 52;
    public static final int STORE_HEADER_POS_LENGTH = 0;
    public static final int STORE_HEADER_POS_DATATYPE = 4;
    public static final int STORE_HEADER_POS_CHECKSUM = 8;
    public static final int STORE_HEADER_POS_QUEUEID = 12;
    public static final int STORE_HEADER_POS_QUEUE_LOGICOFF = 16;
    public static final int STORE_HEADER_POS_RECEIVEDTIME = 24;
    public static final int STORE_HEADER_POS_REPORTADDR = 32;
    public static final int STORE_HEADER_POS_KEYCODE = 36;
    public static final int STORE_HEADER_POS_MSGID = 40;
    public static final int STORE_HEADER_POS_MSGFLAG = 48;
    public static final int STORE_HEADER_POS_MSGDATA = 52;
    public static final int STORE_DATA_TOKER_BEGIN_VALUE = 46766264;
    public static final int STORE_DATA_TOKER_BLANK_VALUE = 46766942;
    public static final long MAX_FILE_ROLL_CHECK_DURATION = 3600000L;
    public static final long MAX_FILE_NO_WRITE_DURATION = 172800000L;
    public static final long MAX_FILE_VALID_DURATION = 604800000L;
    public static final int STORE_INDEX_HEAD_LEN = 28;
    public static final int INDEX_POS_PARTITIONID = 0;
    public static final int INDEX_POS_DATAOFFSET = 4;
    public static final int INDEX_POS_MSG_SIZE = 12;
    public static final int INDEX_POS_KEY_CODE = 16;
    public static final int INDEX_POS_TIME_RECV = 20;
    public static final int MAX_MSG_DATA_STORE_SIZE = 0x1C00000;
    public static final int STORE_MAX_MESSAGE_STORE_LEN = 29360180;
    public static final String DATA_FILE_SUFFIX = ".tube";
    public static final String INDEX_FILE_SUFFIX = ".index";

    public static int getInt(int offset, byte[] data) {
        return ByteBuffer.wrap(data, offset, 4).getInt();
    }

    public static String nameFromOffset(long offset, String fileSuffix) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset) + fileSuffix;
    }

    public static ClientBroker.TransferedMessage getTransferMsg(ByteBuffer dataBuffer, int dataTotalSize, HashMap<String, TrafficInfo> countMap, String statisKeyBase, StringBuilder sBuilder) {
        if (dataBuffer.array().length < dataTotalSize) {
            return null;
        }
        int msgLen = dataBuffer.getInt(0);
        int msgToken = dataBuffer.getInt(4);
        int checkSum = dataBuffer.getInt(8);
        int payLoadLen = msgLen - 48;
        int payLoadOffset = 52;
        if (msgToken != 46766264 || payLoadLen <= 0 || payLoadLen > dataTotalSize - 52) {
            return null;
        }
        long msgId = dataBuffer.getLong(40);
        int flag = dataBuffer.getInt(48);
        int payLoadLen2 = payLoadLen;
        byte[] payLoadData = new byte[payLoadLen];
        System.arraycopy(dataBuffer.array(), payLoadOffset, payLoadData, 0, payLoadLen);
        ClientBroker.TransferedMessage.Builder dataBuilder = ClientBroker.TransferedMessage.newBuilder();
        dataBuilder.setMessageId(msgId);
        dataBuilder.setCheckSum(checkSum);
        dataBuilder.setFlag(flag);
        dataBuilder.setPayLoadData(ByteString.copyFrom((byte[])payLoadData));
        int attrLen = 0;
        String attribute = null;
        if (MessageFlagUtils.hasAttribute((int)flag)) {
            if (payLoadLen < 4) {
                return null;
            }
            attrLen = dataBuffer.getInt(52);
            payLoadOffset += 4;
            if (attrLen > (payLoadLen -= 4)) {
                return null;
            }
            if (attrLen > 0) {
                byte[] attrData = new byte[attrLen];
                System.arraycopy(dataBuffer.array(), payLoadOffset, attrData, 0, attrLen);
                try {
                    attribute = new String(attrData, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        String messageTime = "";
        if (TStringUtils.isNotBlank(attribute) && attribute.contains("$msgTime$")) {
            String[] strAttrs;
            for (String strAttrItem : strAttrs = attribute.split(",")) {
                String[] strItems;
                if (!TStringUtils.isNotBlank((String)strAttrItem) || !strAttrItem.contains("$msgTime$") || (strItems = strAttrItem.split("=")).length <= 1) continue;
                messageTime = strItems[1];
            }
        }
        String baseKey = sBuilder.append(statisKeyBase).append("#").append(messageTime).toString();
        sBuilder.delete(0, sBuilder.length());
        TrafficInfo getCount = countMap.get(baseKey);
        if (getCount == null) {
            countMap.put(baseKey, new TrafficInfo(1L, payLoadLen2));
        } else {
            getCount.addMsgCntAndSize(1L, payLoadLen2);
        }
        ClientBroker.TransferedMessage transferedMessage = dataBuilder.build();
        dataBuilder.clear();
        return transferedMessage;
    }
}

