/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class OffsetStorageInfo
implements Serializable {
    private static final long serialVersionUID = -4232003748320500757L;
    private final String topic;
    private final int brokerId;
    private final int partitionId;
    private final AtomicLong offset = new AtomicLong(0L);
    private long messageId;
    private long lstRstTerm;
    private boolean firstCreate = false;
    private long firstOffset = -2L;
    private long createTime = -2L;
    private boolean modified = false;
    private final AtomicLong lstUpdateTime = new AtomicLong(0L);

    public OffsetStorageInfo(String topic, int brokerId, int partitionId, long lstRstTerm, long offset, long messageId) {
        this(topic, brokerId, partitionId, lstRstTerm, offset, messageId, true, System.currentTimeMillis());
    }

    public OffsetStorageInfo(String topic, int brokerId, int partitionId, long lstRstTerm, long offset, long messageId, boolean firstCreate, long lstUpdateTime) {
        this.topic = topic;
        this.brokerId = brokerId;
        this.partitionId = partitionId;
        this.lstRstTerm = lstRstTerm;
        this.offset.set(offset - offset % 28L);
        this.messageId = messageId;
        this.firstCreate = firstCreate;
        if (firstCreate) {
            this.modified = true;
            this.firstOffset = this.offset.get();
            this.createTime = lstUpdateTime;
        }
        this.lstUpdateTime.set(lstUpdateTime);
    }

    public boolean isFirstCreate() {
        return this.firstCreate;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getLstRstTerm() {
        return this.lstRstTerm;
    }

    public long getOffset() {
        return this.offset.get();
    }

    public long getMessageId() {
        return this.messageId;
    }

    public long getLstUpdateTime() {
        return this.lstUpdateTime.get();
    }

    public boolean isModified() {
        return this.modified;
    }

    public long getFirstOffset() {
        return this.firstOffset;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public long addAndGetOffset(long tmpOffset) {
        this.firstCreate = false;
        this.modified = true;
        this.lstUpdateTime.set(System.currentTimeMillis());
        return this.offset.addAndGet(tmpOffset - tmpOffset % 28L);
    }

    public long getAndSetOffset(long absOffset) {
        this.firstCreate = false;
        this.modified = true;
        this.lstUpdateTime.set(System.currentTimeMillis());
        return this.offset.getAndSet(absOffset - absOffset % 28L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffsetStorageInfo)) {
            return false;
        }
        OffsetStorageInfo that = (OffsetStorageInfo)o;
        if (this.brokerId != that.brokerId) {
            return false;
        }
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.messageId != that.messageId) {
            return false;
        }
        if (this.firstCreate != that.firstCreate) {
            return false;
        }
        if (this.modified != that.modified) {
            return false;
        }
        if (this.lstRstTerm != that.lstRstTerm) {
            return false;
        }
        if (this.lstUpdateTime.get() != that.lstUpdateTime.get()) {
            return false;
        }
        if (!this.topic.equals(that.topic)) {
            return false;
        }
        return this.offset.get() == that.offset.get();
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.brokerId;
        result = 31 * result + this.partitionId;
        result = 31 * result + this.offset.hashCode();
        result = 31 * result + Long.hashCode(this.messageId);
        result = 31 * result + Long.hashCode(this.lstUpdateTime.get());
        result = 31 * result + Long.hashCode(this.lstRstTerm);
        result = 31 * result + (this.firstCreate ? 1 : 0);
        result = 31 * result + (this.modified ? 1 : 0);
        return result;
    }

    public String toString() {
        return new StringBuilder(512).append("OffsetStorageInfo [OffsetStoreKey=").append(this.topic).append("-").append(this.brokerId).append("-").append(this.partitionId).append(", offset=").append(this.offset.get()).append(", messageId=").append(this.messageId).append(", modified=").append(this.modified).append(", firstCreate=").append(this.firstCreate).append(", firstOffset=").append(this.firstOffset).append(", createTime=").append(this.createTime).append(", lstUpdateTime=").append(this.lstUpdateTime.get()).append(", lstRstTerm=").append(this.lstRstTerm).append("]").toString();
    }
}

