/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.offset;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple4;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmItem;
import org.apache.inlong.tubemq.server.broker.offset.OffsetCsmRecord;

public class OffsetHistoryInfo {
    private final int brokerId;
    private final String groupName;
    private boolean isOnLine = false;
    private boolean isFilterCsm = false;
    private final Map<String, Tuple2<Integer, Long>> clientMap = new HashMap<String, Tuple2<Integer, Long>>();
    private final Map<String, Map<Integer, OffsetCsmRecord>> histOffsetMap = new HashMap<String, Map<Integer, OffsetCsmRecord>>();

    public OffsetHistoryInfo(int brokerId, String groupName) {
        this.brokerId = brokerId;
        this.groupName = groupName;
    }

    public void addCfmOffsetInfo(String topicName, int partitionId, long cfmOffset) {
        this.addCsmOffsets(topicName, partitionId, cfmOffset, 0L);
    }

    public void addCsmOffsets(String topicName, int partitionId, long cfmOffset, long tmpOffset) {
        OffsetCsmRecord offsetCsmRecord;
        HashMap<Integer, OffsetCsmRecord> tmpMap;
        int storeId = partitionId < 10000 ? 0 : partitionId / 10000;
        HashMap<Integer, OffsetCsmRecord> storeOffsetMap = this.histOffsetMap.get(topicName);
        if (storeOffsetMap == null && (storeOffsetMap = (HashMap<Integer, OffsetCsmRecord>)this.histOffsetMap.putIfAbsent(topicName, tmpMap = new HashMap<Integer, OffsetCsmRecord>())) == null) {
            storeOffsetMap = tmpMap;
        }
        if ((offsetCsmRecord = storeOffsetMap.get(storeId)) == null) {
            OffsetCsmRecord tmpRecord = new OffsetCsmRecord(storeId);
            offsetCsmRecord = storeOffsetMap.putIfAbsent(storeId, tmpRecord);
            if (offsetCsmRecord == null) {
                offsetCsmRecord = tmpRecord;
            }
        }
        offsetCsmRecord.addCsmOffsets(partitionId, cfmOffset, tmpOffset);
    }

    public void addGroupOnlineInfo(boolean isOnLine, boolean isFilterCsm, String clientId, Long hbTime, String topicName, int partitionId) {
        OffsetCsmRecord offsetCsmRecord;
        HashMap<Integer, OffsetCsmRecord> tmpMap;
        this.isOnLine = isOnLine;
        this.isFilterCsm = isFilterCsm;
        Tuple2<Integer, Long> clientInfo = this.clientMap.get(clientId);
        if (clientInfo == null) {
            this.clientMap.put(clientId, (Tuple2<Integer, Long>)new Tuple2((Object)this.clientMap.size(), (Object)hbTime));
            clientInfo = this.clientMap.get(clientId);
        }
        int storeId = partitionId < 10000 ? 0 : partitionId / 10000;
        HashMap<Integer, OffsetCsmRecord> storeOffsetMap = this.histOffsetMap.get(topicName);
        if (storeOffsetMap == null && (storeOffsetMap = (HashMap<Integer, OffsetCsmRecord>)this.histOffsetMap.putIfAbsent(topicName, tmpMap = new HashMap<Integer, OffsetCsmRecord>())) == null) {
            storeOffsetMap = tmpMap;
        }
        if ((offsetCsmRecord = storeOffsetMap.get(storeId)) == null) {
            OffsetCsmRecord tmpRecord = new OffsetCsmRecord(storeId);
            offsetCsmRecord = storeOffsetMap.putIfAbsent(storeId, tmpRecord);
            if (offsetCsmRecord == null) {
                offsetCsmRecord = tmpRecord;
            }
        }
        offsetCsmRecord.addClientRecId(partitionId, (Integer)clientInfo.getF0());
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Map<String, Map<Integer, OffsetCsmRecord>> getOffsetMap() {
        return this.histOffsetMap;
    }

    public void buildRecordInfo(StringBuilder strBuff, long dataTime) {
        int itemCnt = 0;
        strBuff.append("{\"dt\":").append(dataTime).append(",\"bId\":").append(this.brokerId).append(",\"ver\":").append(3).append(",\"group\":\"").append(this.groupName).append("\",\"on\":").append(this.isOnLine ? 1 : 0).append(",\"flt\":").append(this.isFilterCsm ? 1 : 0).append(",\"clients\":[");
        for (Map.Entry<String, Tuple2<Integer, Long>> entry : this.clientMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            if (itemCnt++ > 0) {
                strBuff.append(",");
            }
            long lastTime = 0L;
            if (entry.getValue().getF1() != null) {
                lastTime = (Long)entry.getValue().getF1();
            }
            strBuff.append("{\"recId\":").append(entry.getValue().getF0()).append(",\"cltId\":\"").append(entry.getKey()).append("\",\"lstTm\":").append(lastTime).append("}");
        }
        itemCnt = 0;
        strBuff.append("],\"records\":[");
        for (Map.Entry<String, Object> entry : this.histOffsetMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            if (itemCnt++ > 0) {
                strBuff.append(",");
            }
            int recordCnt = 0;
            strBuff.append("{\"topic\":\"").append(entry.getKey()).append("\",\"offsets\":[");
            Map csmOffsetRecordMap = (Map)entry.getValue();
            for (OffsetCsmRecord offsetRecord : csmOffsetRecordMap.values()) {
                if (offsetRecord == null) continue;
                if (recordCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("{\"storeId\":").append(offsetRecord.storeId).append(",\"iMin\":").append(offsetRecord.offsetMin).append(",\"iMax\":").append(offsetRecord.offsetMax).append(",\"dMin\":").append(offsetRecord.dataMin).append(",\"dMax\":").append(offsetRecord.dataMax).append(",\"parts\":[");
                int partCnt = 0;
                for (OffsetCsmItem csmOffsetItem : offsetRecord.partitionCsmMap.values()) {
                    if (csmOffsetItem == null) continue;
                    if (partCnt++ > 0) {
                        strBuff.append(",");
                    }
                    if (csmOffsetItem.clientRecId == -1) {
                        strBuff.append("{\"partId\":").append(csmOffsetItem.partitionId).append(",\"iCfm\":").append(csmOffsetItem.cfmOffset).append(",\"iFlt\":").append(csmOffsetItem.inflightOffset).append("}");
                        continue;
                    }
                    strBuff.append("{\"partId\":").append(csmOffsetItem.partitionId).append(",\"iCfm\":").append(csmOffsetItem.cfmOffset).append(",\"iFlt\":").append(csmOffsetItem.inflightOffset).append(",\"recId\":").append(csmOffsetItem.clientRecId).append("}");
                }
                strBuff.append("]}");
            }
            strBuff.append("]}");
        }
        strBuff.append("]}");
    }

    public static boolean parseRecordInfo(Set<String> topicSet, String jsonData, ProcessResult result) {
        JsonObject jsonObject = null;
        try {
            jsonObject = JsonParser.parseString((String)jsonData).getAsJsonObject();
        }
        catch (Throwable e1) {
            result.setFailResult(String.format("Parse history offset value failure, reason is %s", e1.getMessage()));
            return result.isSuccess();
        }
        if (jsonObject == null) {
            result.setFailResult("Parse error, history offset value must be valid json format!");
            return result.isSuccess();
        }
        if (!(OffsetHistoryInfo.isFieldExist(jsonObject, "ver", result) && OffsetHistoryInfo.isFieldExist(jsonObject, "dt", result) && OffsetHistoryInfo.isFieldExist(jsonObject, "offsets", result))) {
            return result.isSuccess();
        }
        int verValue = jsonObject.get("ver").getAsInt();
        if (verValue != 2 && verValue != 3) {
            result.setFailResult("Only support v2 or v3 version in history offset value!");
            return result.isSuccess();
        }
        long dtValue = jsonObject.get("dt").getAsLong();
        boolean found = false;
        ArrayList<Tuple4> resetOffsets = new ArrayList<Tuple4>();
        JsonArray records = jsonObject.get("offsets").getAsJsonArray();
        for (int i = 0; i < records.size(); ++i) {
            JsonObject itemInfo = records.get(i).getAsJsonObject();
            if (itemInfo == null) continue;
            String topicName = itemInfo.get("topic").getAsString();
            if (topicSet != null && !topicSet.isEmpty() && !topicSet.contains(topicName)) continue;
            found = true;
            JsonArray offsets = itemInfo.get("offsets").getAsJsonArray();
            for (int j = 0; j < offsets.size(); ++j) {
                JsonObject storeInfo = offsets.get(j).getAsJsonObject();
                if (storeInfo == null) continue;
                JsonArray partInfos = storeInfo.get("parts").getAsJsonArray();
                for (int k = 0; k < partInfos.size(); ++k) {
                    JsonObject partItem = partInfos.get(k).getAsJsonObject();
                    int partId = partItem.get("partId").getAsInt();
                    long offsetVal = partItem.get("iCfm").getAsLong();
                    resetOffsets.add(new Tuple4((Object)dtValue, (Object)topicName, (Object)partId, (Object)offsetVal));
                }
            }
        }
        if (found) {
            result.setSuccResult(resetOffsets);
        } else {
            result.setFailResult(String.format("Not found required topics %s in history offset value!", topicSet));
        }
        return result.isSuccess();
    }

    private static boolean isFieldExist(JsonObject jsonObject, String key, ProcessResult result) {
        if (!jsonObject.has(key)) {
            result.setFailResult(String.format("FIELD %s is required in history offset value!", key));
            return result.isSuccess();
        }
        return true;
    }
}

