/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class FieldToRowDataUtils {
    private static final long serialVersionUID = 1L;

    public static FieldToRowDataConverter createConverter(LogicalType logicalType) {
        return FieldToRowDataUtils.wrapIntoNullableConverter(FieldToRowDataUtils.createFieldRowConverter(logicalType));
    }

    private static FieldToRowDataConverter wrapIntoNullableConverter(FieldToRowDataConverter converter) {
        return obj -> {
            if (obj == null) {
                return null;
            }
            return converter.convert(obj);
        };
    }

    private static FieldToRowDataConverter createFieldRowConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return obj -> null;
            }
            case BOOLEAN: {
                return obj -> Boolean.parseBoolean(obj.toString());
            }
            case TINYINT: {
                return obj -> Byte.parseByte(obj.toString());
            }
            case SMALLINT: {
                return obj -> Short.parseShort(obj.toString());
            }
            case INTERVAL_YEAR_MONTH: 
            case INTEGER: {
                return obj -> Integer.parseInt(obj.toString());
            }
            case INTERVAL_DAY_TIME: 
            case BIGINT: {
                return obj -> Long.parseLong(obj.toString());
            }
            case FLOAT: {
                return obj -> Float.valueOf(Float.parseFloat(obj.toString()));
            }
            case DOUBLE: {
                return obj -> Double.parseDouble(obj.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return obj -> obj.toString().getBytes();
            }
            case CHAR: 
            case VARCHAR: {
                return obj -> StringData.fromString((String)((String)obj));
            }
            case DATE: {
                return obj -> ((Date)obj).toLocalDate().toEpochDay();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return obj -> ((Time)obj).toLocalTime().toSecondOfDay() * 1000;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                return obj -> TimestampData.fromTimestamp((Timestamp)((Timestamp)obj));
            }
            case DECIMAL: {
                return obj -> DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)obj), (int)10, (int)0);
            }
            case ARRAY: {
                return obj -> {
                    Object[] array = (Object[])obj;
                    FieldToRowDataConverter elementConverter = FieldToRowDataUtils.createFieldRowConverter(((ArrayType)fieldType).getElementType());
                    Object[] converted = Arrays.stream(array).map(elementConverter::convert).toArray();
                    return new GenericArrayData(converted);
                };
            }
            case MAP: {
                return obj -> {
                    FieldToRowDataConverter keyConverter = FieldToRowDataUtils.createFieldRowConverter(((MapType)fieldType).getKeyType());
                    FieldToRowDataConverter valueConverter = FieldToRowDataUtils.createFieldRowConverter(((MapType)fieldType).getValueType());
                    Map map = (Map)obj;
                    HashMap<Object, Object> internalMap = new HashMap<Object, Object>();
                    for (Object k : map.keySet()) {
                        internalMap.put(keyConverter.convert(k), valueConverter.convert(map.get(k)));
                    }
                    return new GenericMapData(internalMap);
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + fieldType);
    }

    public static interface FieldToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

