/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;

@TransformFunction(type="temporal", names={"timestamp_diff", "timestampdiff"}, parameter="(String unit, String datetime_expr1, String datetime_expr2)", descriptions={"- Return \"\" if any parameter is null;", "- Return 'datetime_expr2' \u2212 'datetime_expr1', where 'datetime_expr1' and 'datetime_expr2' are date or datetime expressions.", "Note: 'unit' is one of (MICROSECOND, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, YEAR)."}, examples={"timestampdiff('MONTH','2003-02-01','2003-05-01') = 3"})
public class TimestampDiffFunction
implements ValueParser {
    private final ValueParser unitParser;
    private final ValueParser firstDateTimeParser;
    private final ValueParser secondDateTimeParser;

    public TimestampDiffFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.unitParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.firstDateTimeParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.secondDateTimeParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object unitObj = this.unitParser.parse(sourceData, rowIndex, context);
        Object firstDateTimeObj = this.firstDateTimeParser.parse(sourceData, rowIndex, context);
        Object secondDateTimeObj = this.secondDateTimeParser.parse(sourceData, rowIndex, context);
        if (firstDateTimeObj == null || secondDateTimeObj == null || unitObj == null) {
            return null;
        }
        String unit = OperatorTools.parseString(unitObj).toUpperCase();
        String firstDateTime = OperatorTools.parseString(firstDateTimeObj);
        String secondDateTime = OperatorTools.parseString(secondDateTimeObj);
        if (firstDateTime.isEmpty() || secondDateTime.isEmpty()) {
            return null;
        }
        try {
            LocalDateTime left = Objects.requireNonNull(DateUtil.parseLocalDateTime(firstDateTime));
            LocalDateTime right = Objects.requireNonNull(DateUtil.parseLocalDateTime(secondDateTime));
            switch (unit) {
                case "MICROSECOND": {
                    return ChronoUnit.MICROS.between(left, right);
                }
                case "SECOND": {
                    return ChronoUnit.SECONDS.between(left, right);
                }
                case "MINUTE": {
                    return ChronoUnit.MINUTES.between(left, right);
                }
                case "HOUR": {
                    return ChronoUnit.HOURS.between(left, right);
                }
                case "DAY": {
                    return ChronoUnit.DAYS.between(left, right);
                }
                case "WEEK": {
                    return ChronoUnit.WEEKS.between(left, right);
                }
                case "MONTH": {
                    return ChronoUnit.MONTHS.between(left, right);
                }
                case "QUARTER": {
                    return ChronoUnit.MONTHS.between(left, right) / 3L;
                }
                case "YEAR": {
                    return ChronoUnit.YEARS.between(left, right);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

