/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"startswith"}, parameter="(String s1, String s2)", descriptions={"- Return \"\" if either argument is NULL;", "- Return whether 's2' starts with 's2'."}, examples={"startswith('Apache InLong', 'A') = true"})
public class StartsWithFunction
implements ValueParser {
    private ValueParser exprParser;
    private ValueParser startExprParser;

    public StartsWithFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        if (expressions != null && expressions.size() == 2) {
            this.exprParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.startExprParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object exprObj = this.exprParser.parse(sourceData, rowIndex, context);
        Object startExprObj = this.startExprParser.parse(sourceData, rowIndex, context);
        if (exprObj == null || startExprObj == null) {
            return null;
        }
        if (!this.isSameType(exprObj, startExprObj)) {
            throw new IllegalArgumentException("Both arguments must be of the same type.");
        }
        if (exprObj instanceof byte[] && startExprObj instanceof byte[]) {
            String exprString = new String((byte[])exprObj);
            String startExprString = new String((byte[])startExprObj);
            if (startExprString.isEmpty()) {
                return true;
            }
            return exprString.startsWith(startExprString);
        }
        String exprString = OperatorTools.parseString(exprObj);
        String startExprString = OperatorTools.parseString(startExprObj);
        if (startExprString.isEmpty()) {
            return true;
        }
        return exprString.startsWith(startExprString);
    }

    private boolean isSameType(Object a, Object b) {
        return a instanceof String && b instanceof String || a instanceof byte[] && b instanceof byte[];
    }
}

