/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"lpad"}, parameter="(String str1, Integer len, String str2)", descriptions={"- Return null if any of the three parameters is null or 'len' is less than 0;", "- Return the substring of 'str1' with subscripts in the range of [0, 'len') if 'len' is less than or equal to the length of 'str1';", "- Return \"\" if 'len' is longer than the length of 'str1' and 'str2' is \"\";", "- Return the filled string if 'str2' is not \"\"."}, examples={"lpad('he',7,'xxd') = \"xxdxxhe\"", "lpad('he',1,'') = \"h\""})
public class LpadFunction
implements ValueParser {
    private final ValueParser leftStringParser;
    private final ValueParser lengthParser;
    private final ValueParser rightStringParser;

    public LpadFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.lengthParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.rightStringParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftStringObj = this.leftStringParser.parse(sourceData, rowIndex, context);
        Object lengthObj = this.lengthParser.parse(sourceData, rowIndex, context);
        Object rightStringObj = this.rightStringParser.parse(sourceData, rowIndex, context);
        if (leftStringObj == null || lengthObj == null || rightStringObj == null) {
            return null;
        }
        int len = Integer.parseInt(OperatorTools.parseString(lengthObj));
        if (len < 0) {
            return null;
        }
        String leftStr = OperatorTools.parseString(leftStringObj);
        if (len <= leftStr.length()) {
            return leftStr.substring(0, len);
        }
        String rightStr = OperatorTools.parseString(rightStringObj);
        if (rightStr.isEmpty()) {
            return "";
        }
        int padLen = len - leftStr.length();
        StringBuilder builder = new StringBuilder(padLen);
        while (builder.length() < padLen) {
            builder.append(rightStr);
        }
        return builder.substring(0, padLen).concat(leftStr);
    }
}

