/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.compression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.function.compression.factory.CompressionAlgorithmFactory;
import org.apache.inlong.sdk.transform.process.function.compression.handler.CompressHandler;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="compression", names={"compress"}, parameter="(String string_to_compress [, String compress_type])", descriptions={"- Return \"\" if 'string_to_compress' is NULL;", "- Return \"\" if 'string_to_compress' is \"\";", "- Return the result as a binary string.", "Note: This function supports three compression algorithms: deflater, gzip, and zip. 'compress_type' defaults to defer. In addition, in order to output the compressed results in the form of strings, this method uses the ISO_8859_1 character set."}, examples={"length(compress(replicate(string1,100)),'ISO_8859_1') = 33", "length(compress(''),'ISO_8859_1') = 0"})
public class CompressFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(CompressFunction.class);
    private final ValueParser stringParser;
    private final ValueParser compressTypeParser;
    private final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private final String DEFAULT_COMPRESS_TYPE = "deflater";

    public CompressFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.compressTypeParser = expressions.size() == 2 ? OperatorTools.buildParser((Expression)expressions.get(1)) : null;
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object compressTypeObj;
        Object stringObject = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObject == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObject);
        if (str.isEmpty()) {
            return "";
        }
        String compressType = "deflater";
        if (this.compressTypeParser != null && (compressTypeObj = this.compressTypeParser.parse(sourceData, rowIndex, context)) != null) {
            compressType = OperatorTools.parseString(compressTypeObj);
        }
        compressType = compressType.toLowerCase();
        try {
            byte[] lengthBytes = CompressFunction.intToLowByteArray(str.length());
            CompressHandler handler = CompressionAlgorithmFactory.getCompressHandlerByName(compressType);
            if (handler == null) {
                throw new RuntimeException(compressType + " is not supported.");
            }
            byte[] compressBytes = handler.compress(str.getBytes(this.CHARSET));
            return this.mergeByteArray(lengthBytes, compressBytes);
        }
        catch (Exception e) {
            log.error("Compression failed", (Throwable)e);
            return null;
        }
    }

    private String mergeByteArray(byte[] lengthBytes, byte[] dateBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(lengthBytes.length + dateBytes.length);
        outputStream.write(lengthBytes);
        outputStream.write(dateBytes);
        return new String(outputStream.toByteArray(), this.CHARSET);
    }

    public static byte[] intToLowByteArray(int length) {
        return new byte[]{(byte)(length & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 24 & 0xFF)};
    }
}

