/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NullValue;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="arithmetic", names={"num_nulls"}, parameter="([Expr expr1, Expr expr2, ...])", descriptions={"- Return the number of null arguments."}, examples={"num_nulls(5, null, null, null) = 3"})
public class NumNullsFunction
implements ValueParser {
    private final List<ValueParser> nodeList;

    public NumNullsFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.nodeList = new ArrayList<ValueParser>();
        if (expressions == null || expressions.isEmpty()) {
            return;
        }
        for (Expression expression : expressions) {
            if (expression instanceof NullValue) {
                this.nodeList.add(null);
                continue;
            }
            this.nodeList.add(OperatorTools.buildParser(expression));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        int num = 0;
        for (ValueParser valueParser : this.nodeList) {
            if (valueParser == null) {
                ++num;
                continue;
            }
            Object value = valueParser.parse(sourceData, rowIndex, context);
            if (value != null) continue;
            ++num;
        }
        return num;
    }
}

