/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.arithmetic;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformFunction(type="arithmetic", names={"cot"}, parameter="(Numeric numeric)", descriptions={"- Return \"\" if 'numeric' is NULL;", "- Return the cotangent of the 'numeric' (in radians)."}, examples={"cot(1) = 0.6420926159343306", "cot(0.5) = 1.830487721712452", "cot(-1) = -0.6420926159343306"})
public class CotFunction
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(CotFunction.class);
    private final ValueParser valueParser;

    public CotFunction(Function expr) {
        this.valueParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object valueObj = this.valueParser.parse(sourceData, rowIndex, context);
        if (valueObj == null) {
            return null;
        }
        BigDecimal value = OperatorTools.parseBigDecimal(valueObj);
        double tanValue = Math.tan(value.doubleValue());
        if (tanValue == 0.0) {
            throw new ArithmeticException("Cotangent undefined for this input, tan(x) is zero.");
        }
        return 1.0 / tanValue;
    }
}

