/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.util.List;
import java.util.Map;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.decode.YamlNode;

public class YamlSourceData
implements SourceData {
    public static final String ROOT_KEY = "$root";
    public static final String CHILD_KEY = "$child";
    private YamlNode root;
    private YamlNode childRoot;

    public YamlSourceData(YamlNode root, YamlNode childRoot) {
        this.root = root;
        this.childRoot = childRoot;
    }

    @Override
    public int getRowCount() {
        if (this.childRoot == null) {
            return 1;
        }
        Object value = this.childRoot.getValue();
        if (value instanceof List) {
            return ((List)value).size();
        }
        return 1;
    }

    @Override
    public String getField(int rowNum, String fieldName) {
        try {
            String[] nodeString = fieldName.split("\\.");
            Object cur = null;
            YamlNode last = null;
            int start = -1;
            if (nodeString[0].equals(ROOT_KEY)) {
                cur = this.root;
            } else if (nodeString[0].equals(CHILD_KEY)) {
                cur = ((List)this.childRoot.getValue()).get(rowNum);
            }
            for (int i = 1; i < nodeString.length; ++i) {
                if (cur == null) {
                    cur = last;
                    continue;
                }
                last = cur;
                if (cur instanceof List) {
                    int idx = 0;
                    start = nodeString[i].indexOf(40);
                    if (start != -1) {
                        idx = Integer.parseInt(nodeString[1].substring(start + 1, nodeString[1].indexOf(41)));
                    }
                    cur = ((List)cur).get(idx);
                } else if (cur instanceof Map) {
                    start = nodeString[i].indexOf(40);
                    String key = nodeString[i];
                    if (start != -1) {
                        key = key.substring(0, start);
                    }
                    cur = ((Map)cur).get(key);
                } else if (cur instanceof YamlNode) {
                    cur = ((YamlNode)cur).getValue();
                } else {
                    ++i;
                }
                --i;
            }
            if (cur == null) {
                return "";
            }
            return cur.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

