/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.decode;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.transform.decode.AvroNode;
import org.apache.inlong.sdk.transform.decode.SourceData;

public class AvroSourceData
implements SourceData {
    public static final String ROOT_KEY = "$root";
    public static final String CHILD_KEY = "$child";
    private GenericRecord root;
    private List<GenericRecord> childRoot;
    private Charset srcCharset;

    public AvroSourceData(GenericRecord root, List<GenericRecord> childRoot, Charset srcCharset) {
        this.root = root;
        this.childRoot = childRoot;
        this.srcCharset = srcCharset;
    }

    @Override
    public int getRowCount() {
        if (this.childRoot == null) {
            return 1;
        }
        return this.childRoot.size();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getField(int rowNum, String fieldName) {
        try {
            void var6_12;
            void var6_11;
            String[] nodeStrings;
            ArrayList<AvroNode> childNodes = new ArrayList<AvroNode>();
            for (String nodeString : nodeStrings = fieldName.split("\\.")) {
                childNodes.add(new AvroNode(nodeString));
            }
            if (childNodes.size() == 0) {
                return "";
            }
            AvroNode firstNode = (AvroNode)childNodes.get(0);
            GenericRecord genericRecord = this.root;
            Schema curSchema = this.root.getSchema();
            if (StringUtils.equals((CharSequence)ROOT_KEY, (CharSequence)firstNode.getName())) {
                GenericRecord genericRecord2 = this.root;
                curSchema = this.root.getSchema();
            } else {
                if (!StringUtils.equals((CharSequence)CHILD_KEY, (CharSequence)firstNode.getName())) return "";
                if (rowNum >= this.childRoot.size()) return "";
                GenericRecord genericRecord3 = this.childRoot.get(rowNum);
                curSchema = this.childRoot.get(rowNum).getSchema();
            }
            if (var6_11 == null) {
                return "";
            }
            for (int i = 1; i < childNodes.size(); ++i) {
                AvroNode node = (AvroNode)childNodes.get(i);
                if (curSchema.getType() == Schema.Type.MAP) {
                    Map map = (Map)var6_12;
                    Object mapValue = map.get(new Utf8(node.getName()));
                    if (mapValue == null) {
                        return "";
                    }
                    curSchema = curSchema.getValueType();
                    Object v = mapValue;
                    continue;
                }
                if (curSchema.getType() != Schema.Type.RECORD) {
                    return "";
                }
                Object newElement = ((GenericRecord)var6_12).get(node.getName());
                if (newElement == null) {
                    return "";
                }
                if (!node.isArray()) {
                    curSchema = curSchema.getField(node.getName()).schema();
                    Object object = newElement;
                    continue;
                }
                Object object = this.getElementFromArray(node, newElement, curSchema);
                if (object != null) continue;
                return "";
            }
            return this.getNodeAsString(var6_12, curSchema);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Object getElementFromArray(AvroNode node, Object curElement, Schema curSchema) {
        if (node.getArrayIndices().isEmpty()) {
            return null;
        }
        for (int index : node.getArrayIndices()) {
            if (curSchema.getType() != Schema.Type.ARRAY) {
                return null;
            }
            List newArray = (List)curElement;
            if (index >= newArray.size()) {
                return null;
            }
            curSchema = curSchema.getElementType();
            curElement = newArray.get(index);
        }
        return curElement;
    }

    private String getNodeAsString(Object node, Schema schema) {
        String fieldValue = "";
        Schema.Type fieldType = schema.getType();
        switch (fieldType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: 
            case ENUM: {
                fieldValue = String.valueOf(node);
                break;
            }
            case BYTES: {
                ByteBuffer byteBuffer = (ByteBuffer)node;
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                fieldValue = new String(bytes, this.srcCharset);
                break;
            }
            case FIXED: {
                ByteBuffer byteBuffer = (ByteBuffer)node;
                byte[] bytes = new byte[schema.getFixedSize()];
                fieldValue = new String(bytes, this.srcCharset);
            }
        }
        return fieldValue;
    }
}

