/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import io.debezium.embedded.EmbeddedEngine;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.inlong.agent.pojo.DebeziumOffset;
import org.apache.inlong.agent.utils.DebeziumOffsetSerializer;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.apache.kafka.connect.util.SafeObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InLongFileOffsetBackingStore
extends MemoryOffsetBackingStore {
    public static final String OFFSET_STATE_VALUE = "offset.storage.inlong.state.value";
    public static final int FLUSH_TIMEOUT_SECONDS = 10;
    private static final Logger log = LoggerFactory.getLogger(FileOffsetBackingStore.class);
    private File file;

    public void configure(WorkerConfig config) {
        DebeziumOffset debeziumOffset;
        super.configure(config);
        this.file = new File(config.getString("offset.storage.file.filename"));
        this.start();
        Map conf = config.originals();
        if (!conf.containsKey(OFFSET_STATE_VALUE)) {
            return;
        }
        String stateJson = (String)conf.get(OFFSET_STATE_VALUE);
        DebeziumOffsetSerializer serializer = new DebeziumOffsetSerializer();
        try {
            debeziumOffset = serializer.deserialize(stateJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            log.error("Can't deserialize debezium offset state from JSON: " + stateJson, (Throwable)e);
            throw new RuntimeException(e);
        }
        String engineName = (String)conf.get(EmbeddedEngine.ENGINE_NAME.name());
        JsonConverter keyConverter = new JsonConverter();
        JsonConverter valueConverter = new JsonConverter();
        keyConverter.configure(config.originals(), true);
        HashMap<String, Boolean> valueConfigs = new HashMap<String, Boolean>(conf);
        valueConfigs.put("schemas.enable", false);
        valueConverter.configure(valueConfigs, true);
        OffsetStorageWriter offsetWriter = new OffsetStorageWriter((OffsetBackingStore)this, engineName, (Converter)keyConverter, (Converter)valueConverter);
        offsetWriter.offset(debeziumOffset.sourcePartition, debeziumOffset.sourceOffset);
        if (!offsetWriter.beginFlush()) {
            log.warn("Initialize InLongFileOffsetBackingStore from empty offset state, this shouldn't happen.");
            return;
        }
        Future flushFuture = offsetWriter.doFlush((error, result) -> {
            if (error != null) {
                log.error("Failed to flush initial offset.", error);
            } else {
                log.debug("Successfully flush initial offset.");
            }
        });
        try {
            flushFuture.get(10L, TimeUnit.SECONDS);
            log.info("Flush offsets successfully, partition: {}, offsets: {}", (Object)debeziumOffset.sourcePartition, (Object)debeziumOffset.sourceOffset);
        }
        catch (InterruptedException e) {
            log.warn("Flush offsets interrupted, cancelling.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
        catch (ExecutionException e) {
            log.error("Flush offsets threw an unexpected exception.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
        catch (TimeoutException e) {
            log.error("Timed out waiting to flush offsets to storage.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
    }

    public synchronized void start() {
        super.start();
        log.info("Starting FileOffsetBackingStore with file {}", (Object)this.file);
        this.load();
    }

    public synchronized void stop() {
        super.stop();
        log.info("Stopped FileOffsetBackingStore");
    }

    private void load() {
        try (SafeObjectInputStream is2 = new SafeObjectInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));){
            Object obj = is2.readObject();
            if (!(obj instanceof HashMap)) {
                throw new ConnectException("Expected HashMap but found " + obj.getClass());
            }
            Map raw = (Map)obj;
            this.data = new HashMap();
            for (Map.Entry mapEntry : raw.entrySet()) {
                ByteBuffer key = mapEntry.getKey() != null ? ByteBuffer.wrap((byte[])mapEntry.getKey()) : null;
                ByteBuffer value = mapEntry.getValue() != null ? ByteBuffer.wrap((byte[])mapEntry.getValue()) : null;
                this.data.put(key, value);
            }
        }
        catch (EOFException | NoSuchFileException is2) {
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    protected void save() {
        try (ObjectOutputStream os = new ObjectOutputStream(Files.newOutputStream(this.file.toPath(), new OpenOption[0]));){
            HashMap<byte[], byte[]> raw = new HashMap<byte[], byte[]>();
            for (Map.Entry mapEntry : this.data.entrySet()) {
                byte[] key = mapEntry.getKey() != null ? ((ByteBuffer)mapEntry.getKey()).array() : null;
                byte[] value = mapEntry.getValue() != null ? ((ByteBuffer)mapEntry.getValue()).array() : null;
                raw.put(key, value);
            }
            os.writeObject(raw);
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }
}

