/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection.local;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.agent.plugin.task.logcollection.local.FileTimeComparator;
import org.apache.inlong.agent.plugin.task.logcollection.local.Files;
import org.apache.inlong.agent.plugin.utils.regex.PatternUtil;
import org.apache.inlong.agent.plugin.utils.regex.Scanner;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanner {
    private static final Logger logger = LoggerFactory.getLogger(FileScanner.class);

    public static List<BasicFileInfo> scanTaskBetweenTimes(String originPattern, String cycleUnit, String timeOffset, long startTime, long endTime, boolean isRetry) {
        ArrayList<BasicFileInfo> infos = new ArrayList<BasicFileInfo>();
        List<Scanner.FinalPatternInfo> finalPatternInfos = Scanner.getFinalPatternInfos(originPattern, cycleUnit, timeOffset, startTime, endTime, isRetry);
        for (Scanner.FinalPatternInfo finalPatternInfo : finalPatternInfos) {
            ArrayList<String> allPaths = PatternUtil.cutDirectoryByWildcard(finalPatternInfo.finalPattern);
            String firstDir = allPaths.get(0);
            String secondDir = allPaths.get(0) + File.separator + allPaths.get(1);
            ArrayList<String> fileList = FileScanner.getUpdatedOrNewFiles(firstDir, secondDir, finalPatternInfo.finalPattern, 3L, 4096);
            for (String file : fileList) {
                String dataTime = DateTransUtils.millSecConvertToTimeStr((long)finalPatternInfo.dataTime, (String)cycleUnit);
                BasicFileInfo info = new BasicFileInfo(file, dataTime);
                logger.info("scan new task fileName {} ,dataTime {}", (Object)file, (Object)dataTime);
                infos.add(info);
            }
        }
        return infos;
    }

    private static ArrayList<String> getUpdatedOrNewFiles(String firstDir, String secondDir, String fileName, long depth, int maxFileNum) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<File> readyFiles = new ArrayList<File>();
        if (!new File(firstDir).isDirectory()) {
            return ret;
        }
        for (File pathname : Files.find(firstDir).yieldFilesAndDirectories().recursive().withDepth((int)depth).withDirNameRegex(secondDir).withFileNameRegex(fileName)) {
            if (readyFiles.size() >= maxFileNum) break;
            readyFiles.add(pathname);
        }
        Collections.sort(readyFiles, new FileTimeComparator());
        for (File f : readyFiles) {
            ret.add(f.getAbsolutePath());
        }
        return ret;
    }

    public static class BasicFileInfo {
        public String fileName;
        public String dataTime;

        public BasicFileInfo(String fileName, String dataTime) {
            this.fileName = fileName;
            this.dataTime = dataTime;
        }
    }
}

