/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.AbstractTask;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisTask.class);
    private boolean isAdded = false;
    private String taskId;
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");

    public boolean isProfileValid(TaskProfile profile) {
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        return true;
    }

    @Override
    protected int getInstanceLimit() {
        return 1;
    }

    @Override
    protected void initTask() {
        LOGGER.info("Redis commonInit: {}", (Object)this.taskProfile.toJsonStr());
        this.taskId = this.taskProfile.get("task.redisTask.replId") + "-" + this.taskProfile.get("task.redisTask.isSubscribe");
    }

    @Override
    protected List<InstanceProfile> getNewInstanceList() {
        ArrayList<InstanceProfile> list = new ArrayList<InstanceProfile>();
        if (this.isAdded) {
            return list;
        }
        String dataTime = LocalDateTime.now().format(this.dateTimeFormatter);
        InstanceProfile instanceProfile = this.taskProfile.createInstanceProfile(this.taskId, "H", dataTime, AgentUtils.getCurrentTime());
        LOGGER.info("taskProfile.createInstanceProfile: {}", (Object)instanceProfile.toJsonStr());
        list.add(instanceProfile);
        this.isAdded = true;
        return list;
    }
}

