/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task;

import java.io.IOException;
import java.util.List;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.core.instance.ActionType;
import org.apache.inlong.agent.core.instance.InstanceAction;
import org.apache.inlong.agent.core.instance.InstanceManager;
import org.apache.inlong.agent.core.task.TaskManager;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.file.Task;
import org.apache.inlong.agent.state.State;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTask.class);
    public static final int CORE_THREAD_SLEEP_TIME = 1000;
    public static final int CORE_THREAD_PRINT_TIME = 10000;
    protected static final int DEFAULT_INSTANCE_LIMIT = 1;
    protected TaskProfile taskProfile;
    protected Store basicStore;
    protected TaskManager taskManager;
    private InstanceManager instanceManager;
    protected volatile boolean running = false;
    protected boolean initOK = false;
    protected long lastPrintTime = 0L;
    protected long auditVersion;
    protected long instanceCount = 0L;

    public void init(Object srcManager, TaskProfile taskProfile, Store basicStore) throws IOException {
        this.taskManager = (TaskManager)srcManager;
        this.taskProfile = taskProfile;
        this.basicStore = basicStore;
        this.auditVersion = Long.parseLong(taskProfile.get("task.auditVersion"));
        AbstractTask abstractTask = this;
        this.instanceManager = new InstanceManager(this.taskManager, taskProfile.getTaskId(), this.getInstanceLimit(), basicStore, abstractTask.taskManager.getTaskStore());
        try {
            this.instanceManager.start();
        }
        catch (Exception e) {
            LOGGER.error("start instance manager error: ", (Throwable)e);
        }
        this.initTask();
        this.initOK = true;
    }

    protected abstract int getInstanceLimit();

    protected abstract void initTask();

    protected void releaseTask() {
    }

    public void destroy() {
        this.doChangeState(State.SUCCEEDED);
        if (this.instanceManager != null) {
            this.instanceManager.stop();
        }
        this.releaseTask();
    }

    public TaskProfile getProfile() {
        return this.taskProfile;
    }

    public String getTaskId() {
        if (this.taskProfile == null) {
            return "";
        }
        return this.taskProfile.getTaskId();
    }

    public void addCallbacks() {
    }

    public void run() {
        Thread.currentThread().setName("task-core-" + this.getTaskId());
        this.running = true;
        while (!this.isFinished()) {
            try {
                this.doRun();
            }
            catch (Throwable e) {
                LOGGER.error("do run error: ", e);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            }
            AgentUtils.silenceSleepInMs((long)1000L);
        }
        this.running = false;
    }

    protected void doRun() {
        this.taskPrint();
        if (!this.initOK) {
            return;
        }
        List<InstanceProfile> profileList = this.getNewInstanceList();
        for (InstanceProfile profile : profileList) {
            InstanceAction action = new InstanceAction(ActionType.ADD, profile);
            while (!this.isFinished() && !this.instanceManager.submitAction(action)) {
                LOGGER.error("instance manager action queue is full: taskId {}", (Object)this.getTaskId());
                AgentUtils.silenceSleepInMs((long)1000L);
            }
        }
        this.taskHeartbeat();
    }

    protected abstract List<InstanceProfile> getNewInstanceList();

    protected void taskHeartbeat() {
        AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_TASK_HEARTBEAT, (String)this.taskProfile.getInlongGroupId(), (String)this.taskProfile.getInlongStreamId(), (long)AgentUtils.getCurrentTime(), (int)1, (long)1L, (long)this.auditVersion);
    }

    protected void taskPrint() {
        if (AgentUtils.getCurrentTime() - this.lastPrintTime > 10000L) {
            LOGGER.info("task running! taskId {}", (Object)this.getTaskId());
            this.lastPrintTime = AgentUtils.getCurrentTime();
        }
    }

    protected boolean allInstanceFinished() {
        return this.instanceCount == this.instanceManager.getFinishedInstanceCount();
    }

    protected boolean shouldAddAgain(String fileName, long lastModifyTime) {
        return this.instanceManager.shouldAddAgain(fileName, lastModifyTime);
    }

    protected boolean isFull() {
        return this.instanceManager.isFull();
    }

    public int getInstanceNum() {
        return this.instanceManager.getInstanceNum();
    }
}

