/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.store;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.store.KeyValueEntity;
import org.apache.inlong.agent.store.Store;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperImpl
implements Store {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperImpl.class);
    private static final Gson GSON = new Gson();
    public static final int SLEEP_MS_BETWEEN_RETRIES = 10000;
    public static final int MAX_RETRIES = 10;
    public static final int SESSION_TIMEOUT_MS = 300000;
    public static final int CONNECTION_TIMEOUT_MS = 10000;
    public static final String SPLITTER = "/";
    private static CuratorFramework client;
    private String uniqueKey;
    private static final AgentConfiguration conf;
    private static final String ZK_PRE = "/agent";

    public ZooKeeperImpl(String childPath) {
        this.uniqueKey = ZK_PRE + this.getSplitter() + conf.get("agent.cluster.tag") + this.getSplitter() + conf.get("agent.cluster.name") + this.getSplitter() + conf.get("agent.local.ip") + this.getSplitter() + childPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CuratorFramework getClient() {
        if (client != null) return client;
        Class<ZooKeeperImpl> clazz = ZooKeeperImpl.class;
        synchronized (ZooKeeperImpl.class) {
            if (client != null) return client;
            if (AgentManager.getAgentConfigInfo() == null) {
                throw new RuntimeException("agent config is null");
            }
            RetryNTimes retryPolicy = new RetryNTimes(10000, 10);
            client = CuratorFrameworkFactory.newClient((String)AgentManager.getAgentConfigInfo().getZkUrl(), (int)300000, (int)10000, (RetryPolicy)retryPolicy);
            client.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    public KeyValueEntity get(String key) {
        try {
            byte[] bytes = (byte[])ZooKeeperImpl.getClient().getData().forPath(key);
            return bytes == null ? null : (KeyValueEntity)GSON.fromJson(new String(bytes), KeyValueEntity.class);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("get key value entity error", e);
        }
    }

    public void put(KeyValueEntity entity) {
        try {
            byte[] data = GSON.toJson((Object)entity).getBytes(StandardCharsets.UTF_8);
            Stat stat = (Stat)ZooKeeperImpl.getClient().checkExists().forPath(entity.getKey());
            if (stat == null) {
                ZooKeeperImpl.getClient().create().creatingParentsIfNeeded().forPath(entity.getKey(), data);
            } else {
                ZooKeeperImpl.getClient().setData().forPath(entity.getKey(), data);
            }
        }
        catch (Exception e) {
            LOGGER.error("Path {}, put has exception", (Object)entity.getKey(), (Object)e);
        }
    }

    public KeyValueEntity remove(String key) {
        try {
            Stat stat = (Stat)ZooKeeperImpl.getClient().checkExists().forPath(key);
            if (stat != null) {
                ZooKeeperImpl.getClient().delete().forPath(key);
            }
        }
        catch (Exception e) {
            LOGGER.error("Path {}, remove has exception", (Object)key, (Object)e);
        }
        return null;
    }

    public List<KeyValueEntity> findAll(String prefix) {
        ArrayList<KeyValueEntity> result = new ArrayList<KeyValueEntity>();
        List<String> nodes = this.getLeafNodes(prefix);
        for (int i = 0; i < nodes.size(); ++i) {
            result.add(this.get(nodes.get(i)));
        }
        return result;
    }

    private List<String> getLeafNodes(String path) {
        ArrayList<String> leafNodes = new ArrayList<String>();
        try {
            List children = (List)ZooKeeperImpl.getClient().getChildren().forPath(path);
            if (children.isEmpty()) {
                leafNodes.add(path);
            } else {
                for (int i = 0; i < children.size(); ++i) {
                    leafNodes.addAll(this.getLeafNodes(path + this.getSplitter() + (String)children.get(i)));
                }
            }
        }
        catch (KeeperException.NoNodeException e) {
            return leafNodes;
        }
        catch (Exception e) {
            LOGGER.error("getLeafNodes path {} error", (Object)path, (Object)e);
        }
        return leafNodes;
    }

    public String getSplitter() {
        return SPLITTER;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String replaceKeywords(String source) {
        return source.replace(SPLITTER, "#");
    }

    public void close() throws IOException {
        ZooKeeperImpl.getClient().close();
    }

    static {
        conf = AgentConfiguration.getAgentConf();
    }
}

