/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.snapshot;

import java.io.File;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.plugin.sources.snapshot.AbstractSnapshot;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBSnapshotBase
extends AbstractSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBSnapshotBase.class);
    private static final AgentConfiguration AGENT_CONFIGURATION = AgentConfiguration.getAgentConf();
    private final File file;

    public MongoDBSnapshotBase(String filePath) {
        this.file = new File(filePath);
    }

    @Override
    public String getSnapshot() {
        return ENCODER.encodeToString(this.load(this.file));
    }

    @Override
    public void close() {
    }

    public static String getSnapshotFilePath() {
        String historyPath = AGENT_CONFIGURATION.get("agent.history.path", ".history");
        String parentPath = AGENT_CONFIGURATION.get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
        return AgentUtils.makeDirsIfNotExist((String)historyPath, (String)parentPath).getAbsolutePath();
    }
}

