/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLSource
extends AbstractSource {
    public static final String AGENT_GLOBAL_SQL_SOURCE_PERMIT = "agent.global.sql.source.permit";
    public static final int DEFAULT_AGENT_GLOBAL_SQL_SOURCE_PERMIT = 128000000;
    private int MAX_RECONNECT_TIMES = 3;
    private int RECONNECT_INTERVAL_SECOND = 10;
    private int DEFAULT_FETCH_SIZE = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLSource.class);
    public static final String OFFSET_SEP = ":";
    protected final Integer WAIT_TIMEOUT_MS = 10;
    private String finalSQL;
    private String jdbcUrl;
    private String username;
    private String password;
    private Connection conn;
    protected BlockingQueue<AbstractSource.SourceData> queue;
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("sql-source-pool"));
    private volatile boolean running = false;
    private boolean isMysql = true;
    private volatile boolean fileExist = true;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("sql source init: {}", (Object)profile.toJsonStr());
            AgentConfiguration conf = AgentConfiguration.getAgentConf();
            int permit = conf.getInt(AGENT_GLOBAL_SQL_SOURCE_PERMIT, 128000000);
            MemoryManager.getInstance().addSemaphore(AGENT_GLOBAL_SQL_SOURCE_PERMIT, permit);
            this.finalSQL = profile.getInstanceId();
            this.jdbcUrl = profile.get("task.sqlTask.jdbcUrl").trim().replace("\r", "").replace("\n", "");
            if (this.jdbcUrl.startsWith("jdbc:mysql:")) {
                this.isMysql = true;
            }
            this.username = profile.get("task.sqlTask.username");
            this.password = profile.get("task.sqlTask.jdbcPassword");
            this.queue = new LinkedBlockingQueue<AbstractSource.SourceData>(this.CACHE_QUEUE_SIZE);
            this.initConn();
            EXECUTOR_SERVICE.execute(this.run());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.finalSQL, (Throwable)ex);
        }
    }

    private void initConn() throws SQLException {
        int retryTimes = 0;
        while (this.conn == null) {
            try {
                this.conn = DriverManager.getConnection(this.jdbcUrl, this.username, this.password);
            }
            catch (Exception e) {
                if (++retryTimes >= this.MAX_RECONNECT_TIMES) {
                    throw new SQLException("Failed to connect database after retry " + retryTimes + " times.", e);
                }
                LOGGER.warn("Reconnect database after {} seconds due to the following error: {}", (Object)this.RECONNECT_INTERVAL_SECOND, (Object)e.getMessage());
                AgentUtils.silenceSleepInSeconds((long)this.RECONNECT_INTERVAL_SECOND);
            }
        }
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        int len;
        if (this.queue.isEmpty()) {
            return null;
        }
        int count = 0;
        ArrayList<AbstractSource.SourceData> lines = new ArrayList<AbstractSource.SourceData>();
        for (len = 0; !this.queue.isEmpty() && count < this.BATCH_READ_LINE_COUNT && len < this.BATCH_READ_LINE_TOTAL_LEN && len + ((AbstractSource.SourceData)this.queue.peek()).getData().length <= this.BATCH_READ_LINE_TOTAL_LEN; len += ((AbstractSource.SourceData)this.queue.peek()).getData().length, ++count) {
            lines.add((AbstractSource.SourceData)this.queue.poll());
        }
        MemoryManager.getInstance().release(AGENT_GLOBAL_SQL_SOURCE_PERMIT, len);
        return lines;
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("sql source running, sql: {}", (Object)this.instanceId);
    }

    @Override
    protected String getThreadName() {
        return "sql-source-" + this.taskId + "-" + this.finalSQL;
    }

    private Runnable run() {
        return () -> {
            AgentThreadFactory.nameThread((String)this.getThreadName());
            this.running = true;
            try {
                this.doRun();
            }
            catch (Throwable e) {
                this.fileExist = false;
                LOGGER.error("do run error maybe connect broken: ", e);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
            }
            this.running = false;
        };
    }

    protected void doRun() throws SQLException, IOException {
        try (Statement stmt = this.conn.createStatement(1003, 1007);){
            if (this.isMysql) {
                stmt.setFetchSize(Integer.MIN_VALUE);
            } else {
                stmt.setFetchSize(this.profile.getInt("task.sqlTask.fetchSize", this.DEFAULT_FETCH_SIZE));
            }
            try (ResultSet rs = stmt.executeQuery(this.profile.getInstanceId());){
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                byte[] sep = this.profile.get("task.sqlTask.dataSeparator").getBytes(StandardCharsets.UTF_8);
                while (rs.next()) {
                    boolean suc4Queue;
                    for (int i = 1; i <= columnCount; ++i) {
                        if (i > 1) {
                            bas.write(sep);
                        }
                        bas.write(rs.getBytes(i));
                    }
                    AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, bas.toByteArray(), this.getOffsetString(0L, 0L));
                    boolean suc = false;
                    while (this.isRunnable() && !suc && (suc4Queue = this.waitForPermit(AGENT_GLOBAL_SQL_SOURCE_PERMIT, sourceData.getData().length))) {
                        suc = this.queue.offer(sourceData);
                        if (suc) continue;
                        MemoryManager.getInstance().release(AGENT_GLOBAL_SQL_SOURCE_PERMIT, sourceData.getData().length);
                        AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
                    }
                    bas.reset();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("read from result set error: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("read from result io error: ", (Throwable)e);
            throw e;
        }
    }

    private String getOffsetString(Long lineOffset, Long byteOffset) {
        return lineOffset + OFFSET_SEP + byteOffset;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable && this.fileExist;
    }

    public boolean sourceExist() {
        return this.fileExist;
    }

    @Override
    protected void releaseSource() {
        while (this.running) {
            AgentUtils.silenceSleepInMs((long)1L);
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("close connect error: ", (Throwable)e);
            }
        }
        while (!this.queue.isEmpty()) {
            MemoryManager.getInstance().release(AGENT_GLOBAL_SQL_SOURCE_PERMIT, ((AbstractSource.SourceData)this.queue.poll()).getData().length);
        }
    }

    private boolean waitForPermit(String permitName, int permitLen) {
        boolean suc = false;
        while (!suc) {
            suc = MemoryManager.getInstance().tryAcquire(permitName, permitLen);
            if (suc) continue;
            MemoryManager.getInstance().printDetail(permitName, "sql_source");
            if (!this.isRunnable()) {
                return false;
            }
            AgentUtils.silenceSleepInMs((long)this.WAIT_TIMEOUT_MS.intValue());
        }
        return true;
    }

    protected static class FileOffset {
        private Long lineOffset;
        private Long byteOffset;
        private boolean hasByteOffset;

        public Long getLineOffset() {
            return this.lineOffset;
        }

        public Long getByteOffset() {
            return this.byteOffset;
        }

        public boolean isHasByteOffset() {
            return this.hasByteOffset;
        }

        public void setLineOffset(Long lineOffset) {
            this.lineOffset = lineOffset;
        }

        public void setByteOffset(Long byteOffset) {
            this.byteOffset = byteOffset;
        }

        public void setHasByteOffset(boolean hasByteOffset) {
            this.hasByteOffset = hasByteOffset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileOffset)) {
                return false;
            }
            FileOffset other = (FileOffset)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHasByteOffset() != other.isHasByteOffset()) {
                return false;
            }
            Long this$lineOffset = this.getLineOffset();
            Long other$lineOffset = other.getLineOffset();
            if (this$lineOffset == null ? other$lineOffset != null : !((Object)this$lineOffset).equals(other$lineOffset)) {
                return false;
            }
            Long this$byteOffset = this.getByteOffset();
            Long other$byteOffset = other.getByteOffset();
            return !(this$byteOffset == null ? other$byteOffset != null : !((Object)this$byteOffset).equals(other$byteOffset));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileOffset;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHasByteOffset() ? 79 : 97);
            Long $lineOffset = this.getLineOffset();
            result = result * 59 + ($lineOffset == null ? 43 : ((Object)$lineOffset).hashCode());
            Long $byteOffset = this.getByteOffset();
            result = result * 59 + ($byteOffset == null ? 43 : ((Object)$byteOffset).hashCode());
            return result;
        }

        public String toString() {
            return "SQLSource.FileOffset(lineOffset=" + this.getLineOffset() + ", byteOffset=" + this.getByteOffset() + ", hasByteOffset=" + this.isHasByteOffset() + ")";
        }

        public FileOffset(Long lineOffset, Long byteOffset, boolean hasByteOffset) {
            this.lineOffset = lineOffset;
            this.byteOffset = byteOffset;
            this.hasByteOffset = hasByteOffset;
        }

        public FileOffset() {
        }
    }
}

