/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarSource.class);
    private String topic;
    private String serviceUrl;
    private String subscription;
    private String subscriptionType;
    private PulsarClient pulsarClient;
    private Long timestamp;
    private static final String PULSAR_SUBSCRIPTION_PREFIX = "inlong-agent-";
    private static final String SUBSCRIPTION_CUSTOM = "Custom";
    private boolean isRestoreFromDB = false;
    private Consumer<byte[]> consumer;
    private long offset = 0L;

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("PulsarSource init: {}", (Object)profile.toJsonStr());
            this.topic = profile.getInstanceId();
            this.serviceUrl = profile.get("task.pulsarTask.serviceUrl");
            this.subscription = profile.get("task.pulsarTask.subscription", PULSAR_SUBSCRIPTION_PREFIX + this.inlongStreamId);
            this.subscriptionType = profile.get("task.pulsarTask.subscriptionType", SubscriptionType.Shared.name());
            this.timestamp = profile.getLong("task.pulsarTask.resetTime", 0L);
            this.pulsarClient = PulsarClient.builder().serviceUrl(this.serviceUrl).build();
            this.isRestoreFromDB = profile.getBoolean("task.restoreFromDB", false);
            this.consumer = this.getConsumer();
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.topic, (Throwable)ex);
        }
    }

    @Override
    protected String getThreadName() {
        return "pulsar-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        Message message = null;
        try {
            message = this.consumer.receive(0, TimeUnit.MILLISECONDS);
        }
        catch (PulsarClientException e) {
            LOGGER.error("read from pulsar error", (Throwable)e);
        }
        if (!ObjectUtils.isEmpty((Object)message)) {
            this.offset = message.getSequenceId();
            dataList.add(new AbstractSource.SourceData(this, (byte[])message.getValue(), new String(message.getMessageId().toByteArray(), StandardCharsets.UTF_8)));
            try {
                this.consumer.acknowledge(message);
            }
            catch (PulsarClientException e) {
                LOGGER.error("ack pulsar error", (Throwable)e);
            }
        }
        return dataList;
    }

    private Consumer<byte[]> getConsumer() {
        Consumer consumer = null;
        try {
            String position = this.profile.get("task.pulsarTask.subscriptionPosition", SubscriptionInitialPosition.Latest.name());
            if (position.equals(SUBSCRIPTION_CUSTOM)) {
                consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{this.topic}).subscriptionName(this.subscription).subscriptionType(SubscriptionType.valueOf((String)this.subscriptionType)).subscribe();
                if (!this.isRestoreFromDB) {
                    if (this.timestamp == 0L) {
                        LOGGER.error("Reset consume but timestamp is 0L");
                    } else {
                        consumer.seek(this.timestamp.longValue());
                        LOGGER.info("Reset consume from {}", (Object)this.timestamp);
                    }
                }
            } else {
                consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{this.topic}).subscriptionName(this.subscription).subscriptionInitialPosition(SubscriptionInitialPosition.valueOf((String)position)).subscriptionType(SubscriptionType.valueOf((String)this.subscriptionType)).subscribe();
                LOGGER.info("Skip to reset consume");
            }
            return consumer;
        }
        catch (IllegalArgumentException | PulsarClientException e) {
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (PulsarClientException ex) {
                    LOGGER.error("close consumer error", e);
                }
            }
            LOGGER.error("get consumer error", e);
            return null;
        }
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("pulsar topic is {}, offset is {}", (Object)this.topic, (Object)this.offset);
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (PulsarClientException e) {
                LOGGER.error("close consumer error", (Throwable)e);
            }
        }
    }

    public boolean sourceExist() {
        return true;
    }
}

