/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttSource.class);
    private MqttClient client;
    private LinkedBlockingQueue<DefaultMessage> mqttMessagesQueue;
    private String serverURI;
    private String topic;
    private int qos;
    private String clientId;
    MqttConnectOptions options;

    @Override
    protected String getThreadName() {
        return "mqtt-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("MqttSource init: {}", (Object)profile.toJsonStr());
            this.mqttMessagesQueue = new LinkedBlockingQueue(profile.getInt("task.mqttTask.queueSize", 1000));
            this.serverURI = profile.get("task.mqttTask.serverURI");
            this.instanceId = profile.getInstanceId();
            this.topic = profile.get("task.mqttTask.topic");
            this.qos = profile.getInt("task.mqttTask.qos", 1);
            this.clientId = profile.get("task.mqttTask.clientIdPrefix", "mqtt_client") + "_" + UUID.randomUUID();
            this.initConnectOptions(profile);
            this.mqttConnect();
        }
        catch (Exception e) {
            this.stopRunning();
            throw new FileException("error init stream for {}" + this.topic, (Throwable)e);
        }
    }

    private void initConnectOptions(InstanceProfile profile) {
        this.options = new MqttConnectOptions();
        this.options.setCleanSession(profile.getBoolean("task.mqttTask.cleanSession", false));
        this.options.setConnectionTimeout(profile.getInt("task.mqttTask.connectionTimeOut", 10));
        this.options.setKeepAliveInterval(profile.getInt("task.mqttTask.keepAliveInterval", 20));
        this.options.setUserName(profile.get("task.mqttTask.userName", ""));
        this.options.setPassword(profile.get("task.mqttTask.password", "").toCharArray());
        this.options.setAutomaticReconnect(profile.getBoolean("task.mqttTask.automaticReconnect", true));
        this.options.setMqttVersion(profile.getInt("task.mqttTask.mqttVersion", 0));
    }

    private void mqttConnect() {
        try {
            this.client = new MqttClient(this.serverURI, this.clientId, (MqttClientPersistence)new MemoryPersistence());
            this.client.setCallback(new MqttCallback(){

                public void connectionLost(Throwable cause) {
                    LOGGER.error("the mqtt jobId:{}, serverURI:{}, connection lost, {} ", new Object[]{MqttSource.this.instanceId, MqttSource.this.serverURI, cause});
                    MqttSource.this.reconnect();
                }

                public void messageArrived(String topic, MqttMessage message) throws Exception {
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    headerMap.put("record.topic", topic);
                    headerMap.put("record.messageId", String.valueOf(message.getId()));
                    headerMap.put("record.qos", String.valueOf(message.getQos()));
                    byte[] recordValue = message.getPayload();
                    MqttSource.this.mqttMessagesQueue.offer(new DefaultMessage(recordValue, headerMap));
                }

                public void deliveryComplete(IMqttDeliveryToken token) {
                }
            });
            this.client.connect(this.options);
            this.client.subscribe(this.topic, this.qos);
            LOGGER.info("the mqtt subscribe topic is [{}], qos is [{}]", (Object)this.topic, (Object)this.qos);
        }
        catch (Exception e) {
            LOGGER.error("init mqtt client error {}. jobId:{},serverURI:{},clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
        }
    }

    private void reconnect() {
        if (!this.client.isConnected()) {
            try {
                this.client.connect(this.options);
                LOGGER.info("the mqtt client reconnect success. jobId:{}, serverURI:{}, clientId:{}", new Object[]{this.instanceId, this.serverURI, this.clientId});
            }
            catch (Exception e) {
                LOGGER.error("reconnect mqtt client error {}. jobId:{}, serverURI:{}, clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
            }
        }
    }

    private void disconnect() {
        try {
            this.client.disconnect();
        }
        catch (MqttException e) {
            LOGGER.error("disconnect mqtt client error {}. jobId:{},serverURI:{},clientId:{}", new Object[]{e, this.instanceId, this.serverURI, this.clientId});
        }
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("mqtt topic is {}", (Object)this.topic);
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        try {
            Message msg;
            AbstractSource.SourceData sourceData;
            for (int size = 0; size < this.BATCH_READ_LINE_TOTAL_LEN && (msg = (Message)this.mqttMessagesQueue.poll(1L, TimeUnit.SECONDS)) != null; size += sourceData.getData().length) {
                sourceData = new AbstractSource.SourceData(this, msg.getBody(), "0L");
                dataList.add(sourceData);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("poll {} data from mqtt queue interrupted.", (Object)this.instanceId);
        }
        return dataList;
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        LOGGER.info("release mqtt source");
        if (this.client.isConnected()) {
            this.disconnect();
        }
    }

    public boolean sourceExist() {
        return true;
    }
}

