/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.store.metric;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.metric.AbstractMetric;
import org.apache.inlong.audit.store.metric.MetricItem;
import org.apache.inlong.audit.store.metric.MetricsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MetricsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsManager.class);
    private AbstractMetric metric;
    private final MetricItem metricItem = new MetricItem();
    protected final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor();

    public void init() {
        try {
            String metricClassName = ConfigManager.getInstance().getValue("audit.store.metric.classname", "org.apache.inlong.audit.store.metric.prometheus.StorePrometheusMetric");
            LOGGER.info("Metric class name: {}", (Object)metricClassName);
            Constructor<?> constructor = Class.forName(metricClassName).getDeclaredConstructor(MetricItem.class);
            constructor.setAccessible(true);
            this.metric = (AbstractMetric)constructor.newInstance(this.metricItem);
            this.timer.scheduleWithFixedDelay(() -> {
                this.metric.report();
                this.metricItem.resetAllMetrics();
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            LOGGER.error("Init metrics manager has exception: ", (Throwable)exception);
        }
    }

    public static MetricsManager getInstance() {
        return Holder.access$000();
    }

    public void addReceiveSuccess(long count) {
        this.metricItem.getReceiveCountSuccess().addAndGet(count);
    }

    public void addReceiveFailed(long pack) {
        this.metricItem.getReceiveFailed().addAndGet(pack);
    }

    public void addSendSuccess(long count, long duration) {
        this.metricItem.getSendCountSuccess().addAndGet(count);
        this.metricItem.getSendDuration().addAndGet(duration);
    }

    public void addSendFailed(long count, long duration) {
        this.metricItem.getSendCountFailed().addAndGet(count);
        this.metricItem.getSendDuration().addAndGet(duration);
    }

    public void addInvalidData() {
        this.metricItem.getInvalidData().addAndGet(1L);
    }

    public void shutdown() {
        this.timer.shutdown();
        this.metric.stop();
    }
}

