/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.cluster;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.ClusterResourceProcessForm;
import org.apache.inlong.manager.service.listener.ClusterTaskListenerFactory;
import org.apache.inlong.manager.service.listener.cluster.InitClusterCompleteListener;
import org.apache.inlong.manager.service.listener.cluster.InitClusterFailedListener;
import org.apache.inlong.manager.service.listener.cluster.InitClusterListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncClusterResourceWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(SyncClusterResourceWorkflowDefinition.class);
    @Autowired
    private InitClusterListener initClusterListener;
    @Autowired
    private InitClusterCompleteListener initClusterCompleteListener;
    @Autowired
    private InitClusterFailedListener initClusterFailedListener;
    @Autowired
    private ClusterTaskListenerFactory clusterTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(ClusterResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.initClusterListener);
        process.addListener((ProcessEventListener)this.initClusterFailedListener);
        process.addListener((ProcessEventListener)this.initClusterCompleteListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initMQTask = new ServiceTask();
        initMQTask.setName("InitMQ");
        initMQTask.setDisplayName("Cluster-InitMQ");
        initMQTask.setServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQTask.setListenerFactory((TaskListenerFactory)this.clusterTaskListenerFactory);
        process.addTask((WorkflowTask)initMQTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initMQTask);
        initMQTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_CLUSTER_RESOURCE;
    }
}

