/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.pulsar;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeDTO;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeInfo;
import org.apache.inlong.manager.pojo.queue.pulsar.PulsarTopicInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.pulsar.PulsarSinkDTO;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.queue.pulsar.PulsarOperator;
import org.apache.inlong.manager.service.resource.sink.AbstractStandaloneSinkResourceOperator;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PulsarResourceOperator
extends AbstractStandaloneSinkResourceOperator {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarResourceOperator.class);
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;
    @Autowired
    private PulsarOperator pulsarOperator;
    @Autowired
    private StreamSinkService sinkService;

    @Override
    public Boolean accept(String sinkType) {
        return "PULSAR".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        LOG.info("begin to create sink resources sinkId={}", (Object)sinkInfo.getId());
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOG.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOG.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.checkTaskAndConsumerGroup(sinkInfo);
        this.createTopic(sinkInfo);
        this.assignCluster(sinkInfo);
    }

    private void createTopic(SinkInfo sinkInfo) {
        PulsarSinkDTO pulsarSinkDTO = PulsarSinkDTO.getFromJson((String)sinkInfo.getExtParams());
        PulsarDataNodeDTO pulsarDataNodeInfo = this.getPulsarDataNodeInfo(sinkInfo);
        try {
            PulsarClusterInfo pulsarClusterInfo = ((PulsarClusterInfo.PulsarClusterInfoBuilder)PulsarClusterInfo.builder().adminUrl(pulsarDataNodeInfo.getAdminUrl()).token(pulsarDataNodeInfo.getToken())).build();
            this.pulsarOperator.createTenant(pulsarClusterInfo, pulsarSinkDTO.getPulsarTenant());
            InlongPulsarInfo pulsarInfo = new InlongPulsarInfo();
            this.pulsarOperator.createNamespace(pulsarClusterInfo, pulsarInfo, pulsarSinkDTO.getPulsarTenant(), pulsarSinkDTO.getNamespace());
            String queueModel = pulsarSinkDTO.getPartitionNum() > 0 ? "PARALLEL" : "SERIAL";
            PulsarTopicInfo topicInfo = PulsarTopicInfo.builder().pulsarTenant(pulsarSinkDTO.getPulsarTenant()).namespace(pulsarSinkDTO.getNamespace()).topicName(pulsarSinkDTO.getTopic()).numPartitions(pulsarSinkDTO.getPartitionNum()).queueModule(queueModel).build();
            this.pulsarOperator.createTopic(pulsarClusterInfo, topicInfo);
            String info = "success to create Pulsar resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), "success to create Pulsar resource");
            LOG.info("success to create Pulsar resource for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Exception e) {
            LOG.error("init pulsar admin error", (Throwable)e);
            throw new BusinessException();
        }
    }

    private PulsarDataNodeDTO getPulsarDataNodeInfo(SinkInfo sinkInfo) {
        String dataNodeName = sinkInfo.getDataNodeName();
        Preconditions.expectNotBlank((String)dataNodeName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"Pulsar admin url not specified and data node is empty");
        PulsarDataNodeInfo dataNodeInfo = (PulsarDataNodeInfo)this.dataNodeHelper.getDataNodeInfo(dataNodeName, sinkInfo.getSinkType());
        PulsarDataNodeDTO pulsarDataNodeDTO = new PulsarDataNodeDTO();
        CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)pulsarDataNodeDTO, (boolean)true);
        return pulsarDataNodeDTO;
    }
}

