/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.hudi;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.inlong.manager.service.resource.sink.hudi.HudiFileFormat;

public class HudiUtils {
    private static final String COMMIT_TIME_METADATA_FILE_NAME = "_Hudi_commit_time";
    private static final String COMMIT_SEQNO_METADATA_FILE_NAME = "_Hudi_commit_seqno";
    private static final String RECORD_KEY_METADATA_FILE_NAME = "_Hudi_record_key";
    private static final String PARTITION_PATH_METADATA_FILE_NAME = "_Hudi_partition_path";
    private static final String METADATA_FILE_NAME = "_Hudi_file_name";
    private static final String OPERATION_METADATA_FILE_NAME = "_Hudi_operation";
    public static final String IS_QUERY_AS_RO_TABLE = "Hudi.query.as.ro.table";
    private static final Set<String> HUDI_METADATA_FILES = Sets.newHashSet((Object[])new String[]{"_Hudi_commit_time", "_Hudi_commit_seqno", "_Hudi_record_key", "_Hudi_partition_path", "_Hudi_file_name", "_Hudi_operation"});
    private static final String PARQUET_REALTIME_INPUT_FORMAT_NAME = "org.apache.hudi.hadoop.realtime.HudiParquetRealtimeInputFormat";
    private static final String PARQUET_INPUT_FORMAT_NAME = "org.apache.hudi.hadoop.HudiParquetInputFormat";
    private static final String HFILE_REALTIME_INPUT_FORMAT_NAME = "org.apache.hudi.hadoop.realtime.HudiHFileRealtimeInputFormat";
    private static final String HFILE_INPUT_FORMAT_NAME = "org.apache.hudi.hadoop.HudiHFileInputFormat";
    private static final String ORC_INPUT_FORMAT_NAME = "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat";
    private static final String PARQUET_HIVE_SER_DE_CLASS_NAME = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
    private static final String ORC_SER_DE_CLASS_NAME = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
    private static final String MAPRED_PARQUET_OUTPUT_FORMAT_NAME = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
    private static final String ORC_OUTPUT_FORMAT_NAME = "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat";

    public static boolean isMetadataFile(String fileName) {
        return HUDI_METADATA_FILES.contains(fileName);
    }

    public static String getInputFormatClassName(HudiFileFormat baseFileFormat, boolean realtime) {
        switch (baseFileFormat) {
            case PARQUET: {
                if (realtime) {
                    return PARQUET_REALTIME_INPUT_FORMAT_NAME;
                }
                return PARQUET_INPUT_FORMAT_NAME;
            }
            case HFILE: {
                if (realtime) {
                    return HFILE_REALTIME_INPUT_FORMAT_NAME;
                }
                return HFILE_INPUT_FORMAT_NAME;
            }
            case ORC: {
                return ORC_INPUT_FORMAT_NAME;
            }
        }
        throw new RuntimeException("Hudi InputFormat not implemented for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getOutputFormatClassName(HudiFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: 
            case HFILE: {
                return MAPRED_PARQUET_OUTPUT_FORMAT_NAME;
            }
            case ORC: {
                return ORC_OUTPUT_FORMAT_NAME;
            }
        }
        throw new RuntimeException("No OutputFormat for base file format " + (Object)((Object)baseFileFormat));
    }

    public static String getSerDeClassName(HudiFileFormat baseFileFormat) {
        switch (baseFileFormat) {
            case PARQUET: 
            case HFILE: {
                return PARQUET_HIVE_SER_DE_CLASS_NAME;
            }
            case ORC: {
                return ORC_SER_DE_CLASS_NAME;
            }
        }
        throw new RuntimeException("No SerDe for base file format " + (Object)((Object)baseFileFormat));
    }
}

