/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue;

import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueResourceOperatorFactory {
    @Autowired
    private List<QueueResourceOperator> operatorList;

    public QueueResourceOperator getInstance(String mqType) {
        return this.operatorList.stream().filter(inst -> inst.accept(mqType)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORT, String.format(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORT.getMessage(), mqType)));
    }
}

