/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.cos;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.cos.COSDataNodeDTO;
import org.apache.inlong.manager.pojo.node.cos.COSDataNodeInfo;
import org.apache.inlong.manager.pojo.node.cos.COSDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class COSDataNodeOperator
extends AbstractDataNodeOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "COS";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        COSDataNodeInfo dataNodeInfo = new COSDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)dataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            COSDataNodeDTO dto = COSDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)dataNodeInfo);
        }
        return dataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        COSDataNodeRequest dataNodeRequest = (COSDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)dataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            COSDataNodeDTO dto = COSDataNodeDTO.getFromRequest((COSDataNodeRequest)dataNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for COS node: %s", e.getMessage()));
        }
    }
}

