/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group.apply;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CancelApplyProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(CancelApplyProcessListener.class);
    @Autowired
    private InlongGroupEntityMapper groupMapper;

    public ProcessEvent event() {
        return ProcessEvent.CANCEL;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyGroupProcessForm form = (ApplyGroupProcessForm)context.getProcessForm();
        List<String> groupList = Arrays.asList(form.getInlongGroupId().split(","));
        for (String groupId : groupList) {
            log.info("begin to execute CancelApplyProcessListener for groupId={}", (Object)groupId);
            InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
            if (entity == null) {
                throw new WorkflowListenerException("InlongGroup not found with groupId=" + groupId);
            }
            if (!Objects.equals(GroupStatus.TO_BE_APPROVAL.getCode(), entity.getStatus())) {
                throw new WorkflowListenerException(String.format("Current status [%s] was not allowed to cancel", GroupStatus.forCode((int)entity.getStatus())));
            }
            String operator = context.getOperator();
            this.groupMapper.updateStatus(groupId, GroupStatus.TO_BE_SUBMIT.getCode(), operator);
            log.info("success to execute CancelApplyProcessListener for groupId={}", (Object)groupId);
        }
        return ListenerResult.success();
    }
}

