/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.datatype;

import java.util.List;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.service.datatype.DataTypeOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataTypeOperatorFactory {
    @Autowired
    private List<DataTypeOperator> operatorList;

    public DataTypeOperator getInstance(DataTypeEnum type) {
        return this.operatorList.stream().filter(inst -> inst.accept(type)).findFirst().orElseThrow(() -> new BusinessException(ErrorCodeEnum.DATA_NODE_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.DATA_NODE_TYPE_NOT_SUPPORTED.getMessage(), type)));
    }
}

