/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.inlong.common.pojo.sort.mq.PulsarClusterConfig;
import org.apache.inlong.common.pojo.sort.mq.TubeClusterConfig;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.ClusterConfigEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.mapper.ClusterConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.cluster.tubemq.TubeClusterInfo;
import org.apache.inlong.manager.service.cluster.ClusterConfigService;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.apache.inlong.manager.service.cluster.InlongClusterOperatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterConfigServiceImpl
implements ClusterConfigService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigServiceImpl.class);
    @Autowired
    private ClusterConfigEntityMapper clusterConfigEntityMapper;
    @Autowired
    private InlongClusterEntityMapper clusterEntityMapper;
    @Autowired
    private InlongClusterOperatorFactory clusterOperatorFactory;

    @Override
    public boolean refresh(String clusterTag, String operator) {
        try {
            ClusterConfigEntity clusterConfigEntity;
            ObjectMapper objectMapper = new ObjectMapper();
            ClusterPageRequest request = ClusterPageRequest.builder().clusterTag(clusterTag).typeList(Arrays.asList("TUBEMQ", "PULSAR", "KAFKA")).build();
            List clusterEntityList = this.clusterEntityMapper.selectByCondition(request);
            if (CollectionUtils.isEmpty((Collection)clusterEntityList)) {
                throw new BusinessException("Current cluster tag not contain MQ clusters");
            }
            List typeList = clusterEntityList.stream().map(InlongClusterEntity::getType).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(typeList) && typeList.size() > 1) {
                throw new BusinessException("Current cluster tag can not contain multiple MQ types");
            }
            ClusterConfigEntity existEntity = this.clusterConfigEntityMapper.selectByClusterTag(clusterTag);
            ClusterConfigEntity clusterConfigEntity2 = clusterConfigEntity = existEntity == null ? new ClusterConfigEntity() : existEntity;
            if (CollectionUtils.isNotEmpty((Collection)clusterEntityList)) {
                String clusterType = ((InlongClusterEntity)clusterEntityList.get(0)).getType();
                InlongClusterOperator clusterOperator = this.clusterOperatorFactory.getInstance(clusterType);
                ArrayList<Object> list = new ArrayList<Object>();
                block10: for (InlongClusterEntity clusterInfo : clusterEntityList) {
                    switch (clusterType) {
                        case "PULSAR": {
                            PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)clusterOperator.getFromEntity(clusterInfo);
                            PulsarClusterConfig pulsarClusterConfig = (PulsarClusterConfig)CommonBeanUtils.copyProperties((Object)pulsarCluster, PulsarClusterConfig::new, (boolean)true);
                            pulsarClusterConfig.setVersion(pulsarCluster.getVersion());
                            pulsarClusterConfig.setClusterName(pulsarCluster.getName());
                            pulsarClusterConfig.setServiceUrl(pulsarCluster.getUrl());
                            list.add(pulsarClusterConfig);
                            continue block10;
                        }
                        case "TUBEMQ": {
                            TubeClusterInfo tubeClusterInfo = (TubeClusterInfo)clusterOperator.getFromEntity(clusterInfo);
                            TubeClusterConfig tubeClusterConfig = (TubeClusterConfig)CommonBeanUtils.copyProperties((Object)tubeClusterInfo, TubeClusterConfig::new, (boolean)true);
                            tubeClusterConfig.setVersion(tubeClusterInfo.getVersion());
                            tubeClusterConfig.setClusterName(tubeClusterInfo.getName());
                            tubeClusterConfig.setMasterAddress(tubeClusterInfo.getUrl());
                            list.add(tubeClusterConfig);
                            continue block10;
                        }
                    }
                    throw new BusinessException(String.format(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORTED.getMessage(), clusterType));
                }
                clusterConfigEntity.setConfigParams(objectMapper.writeValueAsString(list));
                clusterConfigEntity.setClusterType(clusterType);
            }
            clusterConfigEntity.setClusterTag(clusterTag);
            clusterConfigEntity.setModifier(operator);
            if (existEntity == null) {
                clusterConfigEntity.setCreator(operator);
                this.clusterConfigEntityMapper.insert(clusterConfigEntity);
            } else {
                this.clusterConfigEntityMapper.updateByIdSelective(clusterConfigEntity);
            }
        }
        catch (Exception e) {
            String errMsg = String.format("push cluster config failed for cluster Tag=%s", clusterTag);
            LOGGER.error(errMsg, (Throwable)e);
            throw new WorkflowListenerException(errMsg);
        }
        return true;
    }
}

