/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.zk.AgentZkClusterDTO;
import org.apache.inlong.manager.pojo.cluster.zk.AgentZkClusterInfo;
import org.apache.inlong.manager.pojo.cluster.zk.AgentZkClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentZkClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentZkClusterOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "AGENT_ZK";
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        AgentZkClusterRequest agentZkClusterRequest = (AgentZkClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)agentZkClusterRequest, (Object)targetEntity, (boolean)true);
        try {
            AgentZkClusterDTO dto = AgentZkClusterDTO.getFromRequest((AgentZkClusterRequest)agentZkClusterRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_INFO_INCORRECT, String.format("serialize extParams of agent zk Cluster failure: %s", e.getMessage()));
        }
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        AgentZkClusterInfo info = new AgentZkClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)info);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            AgentZkClusterDTO dto = AgentZkClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)info);
        }
        return info;
    }

    @Override
    public Object getClusterInfo(InlongClusterEntity entity) {
        AgentZkClusterInfo agentZkClusterInfo = (AgentZkClusterInfo)this.getFromEntity(entity);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", agentZkClusterInfo.getUrl());
        return map;
    }
}

