/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.workflow;

import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.exceptions.WorkflowException;

public enum WorkflowAction {
    START("initiation process"),
    APPROVE("agree"),
    REJECT("reject"),
    CANCEL("withdrawal"),
    TRANSFER("Turn to do"),
    TERMINATE("abandoned"),
    COMPLETE("automatic completion");

    private final String displayName;

    private WorkflowAction(String displayName) {
        this.displayName = displayName;
    }

    public static WorkflowAction fromTaskEvent(TaskEvent taskEvent) {
        switch (taskEvent) {
            case CREATE: {
                return null;
            }
            case APPROVE: {
                return APPROVE;
            }
            case REJECT: {
                return REJECT;
            }
            case TRANSFER: {
                return TRANSFER;
            }
            case CANCEL: {
                return CANCEL;
            }
            case COMPLETE: 
            case FAIL: {
                return COMPLETE;
            }
            case TERMINATE: {
                return TERMINATE;
            }
        }
        throw new WorkflowException("unknown taskEvent " + taskEvent);
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

