/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.inlong.sort.formats.inlongmsg.FailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.IgnoreFailureHandler;
import org.apache.inlong.sort.formats.inlongmsg.NoOpFailureHandler;
import org.apache.inlong.sort.formats.metrics.FormatMetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultDeserializationSchema<T>
implements DeserializationSchema<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeserializationSchema.class);
    protected FailureHandler failureHandler;
    protected transient FormatMetricGroup formatMetricGroup;

    public DefaultDeserializationSchema(boolean ignoreErrors) {
        this.failureHandler = ignoreErrors ? new IgnoreFailureHandler() : new NoOpFailureHandler();
    }

    public DefaultDeserializationSchema(FailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    public void open(DeserializationSchema.InitializationContext context) {
        try {
            MetricGroup metricGroup = context.getMetricGroup();
            Preconditions.checkArgument((boolean)(metricGroup instanceof FormatMetricGroup), (Object)("Expecting FormatMetricGroup, but got " + metricGroup.getClass().getName()));
            this.formatMetricGroup = (FormatMetricGroup)metricGroup;
        }
        catch (Exception ignore) {
            LOG.warn("FormatGroup initialization error, no format metric will be accumulated", (Throwable)ignore);
        }
    }

    public T deserialize(byte[] bytes) throws IOException {
        try {
            T result = this.deserializeInternal(bytes);
            return result;
        }
        catch (Exception e) {
            if (this.formatMetricGroup != null) {
                this.formatMetricGroup.getNumRecordsDeserializeError().inc(1L);
            }
            if (this.failureHandler != null && this.failureHandler.isIgnoreFailure()) {
                if (this.formatMetricGroup != null) {
                    this.formatMetricGroup.getNumRecordsDeserializeErrorIgnored().inc(1L);
                }
                if (bytes == null) {
                    LOG.warn("Could not properly deserialize the data null.");
                } else {
                    LOG.warn("Could not properly deserialize the data {}.", (Object)StringUtils.byteToHexString((byte[])bytes), (Object)e);
                }
                return null;
            }
            throw new IOException("Failed to deserialize data " + StringUtils.byteToHexString((byte[])bytes), e);
        }
    }

    protected abstract T deserializeInternal(byte[] var1) throws Exception;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultDeserializationSchema that = (DefaultDeserializationSchema)object;
        return Objects.equals(this.failureHandler, that.failureHandler);
    }

    public int hashCode() {
        return Objects.hash(this.failureHandler);
    }
}

