/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import com.google.common.base.Splitter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.LowLevelInlongClient;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.util.HttpUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.InlongGroupBriefInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupPageRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowLevelInlongClientImpl
implements LowLevelInlongClient {
    private static final Logger log = LoggerFactory.getLogger(LowLevelInlongClientImpl.class);
    private static final String URL_SPLITTER = ",";
    private static final String HOST_SPLITTER = ":";
    private final ClientConfiguration configuration;

    public LowLevelInlongClientImpl(String serviceUrl, ClientConfiguration configuration) {
        Map hostPorts = Splitter.on((String)URL_SPLITTER).withKeyValueSeparator(HOST_SPLITTER).split((CharSequence)serviceUrl);
        if (MapUtils.isEmpty((Map)hostPorts)) {
            throw new IllegalArgumentException(String.format("Unsupported serviceUrl : %s", serviceUrl));
        }
        configuration.setServiceUrl(serviceUrl);
        boolean isConnective = false;
        for (Map.Entry hostPort : hostPorts.entrySet()) {
            int port;
            String host = (String)hostPort.getKey();
            if (!HttpUtils.checkConnectivity((String)host, (int)(port = Integer.parseInt((String)hostPort.getValue())), (int)configuration.getReadTimeout(), (TimeUnit)configuration.getTimeUnit())) continue;
            configuration.setBindHost(host);
            configuration.setBindPort(port);
            isConnective = true;
            break;
        }
        if (!isConnective) {
            throw new RuntimeException(String.format("%s is not connective", serviceUrl));
        }
        this.configuration = configuration;
    }

    @Override
    public Integer saveCluster(ClusterRequest request) {
        InlongClusterClient clusterClient = ClientUtils.getClientFactory(this.configuration).getClusterClient();
        return clusterClient.saveCluster(request);
    }

    @Override
    public PageResult<InlongGroupBriefInfo> listGroup(InlongGroupPageRequest request) {
        InlongGroupClient groupClient = ClientUtils.getClientFactory(this.configuration).getGroupClient();
        return groupClient.listGroups(request);
    }

    public ClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

